/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.PracticeExperienceInfoEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IGetPracticeExperiencePresenter;
import com.kangxin.doctor.worktable.view.IGetPracticeExperienceView;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.List;

public class GetPracticeExperiencePresenter
implements IGetPracticeExperiencePresenter {
    private IGetPracticeExperienceView mGetPracticeExperience;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public GetPracticeExperiencePresenter(IGetPracticeExperienceView getPracticeExperienceView) {
        this.mGetPracticeExperience = getPracticeExperienceView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void getGetPracticeExperience(boolean isShowLoading) {
        Context context = this.mGetPracticeExperience.injectContext();
        String docId = VertifyDataUtil.getInstance((Context)context).getDoctorId();
        Observable observable = this.mUserModule.getNativeUserInfo(context).flatMap(loginSuccess -> this.mOrderModule.getPracticeExperiencel(docId));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<List<PracticeExperienceInfoEntity>>>(){

                public void onReqNext(ResponseBody<List<PracticeExperienceInfoEntity>> responseBody) {
                    if (responseBody == null) {
                        return;
                    }
                    GetPracticeExperiencePresenter.this.mGetPracticeExperience.getPracticeExperienceInfoSuccess((List)responseBody.getResult());
                    this.onComplete();
                }

                public void onReqErr(Throwable e) {
                    super.onReqErr(e);
                    GetPracticeExperiencePresenter.this.mGetPracticeExperience.error(e.toString());
                    this.onComplete();
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<List<PracticeExperienceInfoEntity>>>(){

                public void onNext(ResponseBody<List<PracticeExperienceInfoEntity>> responseBody) {
                    if (responseBody == null) {
                        return;
                    }
                    GetPracticeExperiencePresenter.this.mGetPracticeExperience.getPracticeExperienceInfoSuccess((List)responseBody.getResult());
                }

                public void onError(Throwable e) {
                    GetPracticeExperiencePresenter.this.mGetPracticeExperience.error(e.toString());
                }
            });
        }
    }
}

