/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.PracticeExperienceSelectHospitalEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IPracticeExperienceSelectHospitalPresenter;
import com.kangxin.doctor.worktable.view.IGetPracticeExperienceSelectHospitalView;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.List;

public class GetPracticeExperienceSelectHospitalListPresenter
implements IPracticeExperienceSelectHospitalPresenter {
    private IGetPracticeExperienceSelectHospitalView mHospitalListView;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public GetPracticeExperienceSelectHospitalListPresenter(IGetPracticeExperienceSelectHospitalView hospitalListView) {
        this.mHospitalListView = hospitalListView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void getHospitalList(String requestParam, boolean isShowLoading) {
        Observable observable = this.mUserModule.getNativeUserInfo(this.mHospitalListView.injectContext()).flatMap(loginSuccess -> this.mOrderModule.getPracticeExperiencelSelectHospital(requestParam));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<List<PracticeExperienceSelectHospitalEntity>>>(){

                public void onReqNext(ResponseBody<List<PracticeExperienceSelectHospitalEntity>> responseBody) {
                    if (responseBody == null) {
                        return;
                    }
                    GetPracticeExperienceSelectHospitalListPresenter.this.mHospitalListView.getHospitalInfoSuccess((List)responseBody.getResult());
                    this.onComplete();
                }

                public void onReqErr(Throwable e) {
                    super.onReqErr(e);
                    GetPracticeExperienceSelectHospitalListPresenter.this.mHospitalListView.error(e.toString());
                    this.onComplete();
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<List<PracticeExperienceSelectHospitalEntity>>>(){

                public void onNext(ResponseBody<List<PracticeExperienceSelectHospitalEntity>> responseBody) {
                    if (responseBody == null) {
                        return;
                    }
                    GetPracticeExperienceSelectHospitalListPresenter.this.mHospitalListView.getHospitalInfoSuccess((List)responseBody.getResult());
                }

                public void onError(Throwable e) {
                    GetPracticeExperienceSelectHospitalListPresenter.this.mHospitalListView.error(e.toString());
                }
            });
        }
    }
}

