/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.response.PatientDetailEntity;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.INewApplyDetailPresenter;
import com.kangxin.doctor.worktable.view.INewApplyDetailView;
import io.reactivex.Observer;
import io.reactivex.functions.Function;

public class NewApplyDetailPresenter
implements INewApplyDetailPresenter {
    private IOrderModule mOrderModule;
    private INewApplyDetailView mView;

    public NewApplyDetailPresenter(INewApplyDetailView mView) {
        this.mView = mView;
        this.mOrderModule = new OrderModule();
    }

    @Override
    public void getNewApplyDetail(String orderUuid) {
        this.mOrderModule.getOrderDetail(orderUuid).filter(responseBody -> {
            Integer code = responseBody.getCode();
            return code == 200;
        }).map((Function)new Function<ResponseBody<OrderDetailEntity>, PatientDetailEntity>(){

            public PatientDetailEntity apply(ResponseBody<OrderDetailEntity> orderEntity) throws Exception {
                PatientDetailEntity patientDetailEntity = new PatientDetailEntity();
                OrderDetailEntity result = (OrderDetailEntity)orderEntity.getResult();
                patientDetailEntity.setPatId(result.getPatientId());
                patientDetailEntity.setCaseAttachmentList(result.getCaseAttachmentList());
                patientDetailEntity.setPatIdCard(result.getPatIdCard());
                patientDetailEntity.setPatientSex(result.getPatientSex());
                patientDetailEntity.setPatientAge(result.getPatientAge());
                patientDetailEntity.setPatientTel(result.getPatientTel());
                patientDetailEntity.setPatCaseMainSuit(result.getPatCaseMainSuit());
                patientDetailEntity.setPatientName(result.getPatientName());
                patientDetailEntity.setPatCreateTime(result.getOrderCreateTimeStr());
                patientDetailEntity.setOrderId(Long.valueOf(result.getOrderId()));
                patientDetailEntity.setCaseAttachmentList(result.getCaseAttachmentList());
                return patientDetailEntity;
            }
        }).doOnNext(responseBody -> this.mView.fullOrderDetail((PatientDetailEntity)responseBody)).subscribe((Observer)new ProgressDialogObserver<PatientDetailEntity>(){

            public void onNext(PatientDetailEntity patientDetailEntity) {
            }

            protected Context attachContext() {
                return NewApplyDetailPresenter.this.mView.injectContext();
            }
        });
    }
}

