/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BasePresenter;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.OrderItemEntity;
import com.kangxin.common.byh.entity.response.PatientDetailEntity;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IPatientNewApplyPresenter;
import com.kangxin.doctor.worktable.view.IPatientNewApplyListView;
import io.reactivex.Observer;
import java.util.List;

public class PatientNewApplyPresenter
extends BasePresenter
implements IPatientNewApplyPresenter {
    private IPatientNewApplyListView mPatientNewApplyListView;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public PatientNewApplyPresenter(IPatientNewApplyListView mPatientNewApplyListView) {
        this.mPatientNewApplyListView = mPatientNewApplyListView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void getPatientNewApplyList(final boolean isGetMore) {
        int docId = Integer.parseInt(VertifyDataUtil.getInstance((Context)this.mPatientNewApplyListView.injectContext()).getDoctorId());
        this.mOrderModule.getOrderList(docId, 1, 6, this.getPageIndex(isGetMore), this.getPageSize()).subscribe((Observer)new ProgressDialogObserver<ResponseBody<List<OrderItemEntity>>>(){

            public void onNext(ResponseBody<List<OrderItemEntity>> listResponseBody) {
                PatientNewApplyPresenter.this.fullData(PatientNewApplyPresenter.this.mPatientNewApplyListView, (List)listResponseBody.getResult(), isGetMore);
                this.onComplete();
            }

            protected Context attachContext() {
                return PatientNewApplyPresenter.this.mPatientNewApplyListView.injectContext();
            }
        });
    }

    @Override
    public void getPatientDetail(String orderViewId, final boolean isToDetail) {
        this.mOrderModule.getOrderDetail(orderViewId).map(orderDetailEntityResponseBody -> (OrderDetailEntity)orderDetailEntityResponseBody.getResult()).subscribe((Observer)new ProgressDialogObserver<OrderDetailEntity>(){

            public void onNext(OrderDetailEntity orderDetailEntity) {
                PatientDetailEntity patientDetailEntity = PatientDetailEntity.parsePatientDetailEntity((OrderDetailEntity)orderDetailEntity);
                if (isToDetail) {
                    PatientNewApplyPresenter.this.mPatientNewApplyListView.toPatientDetail(patientDetailEntity);
                } else {
                    PatientNewApplyPresenter.this.mPatientNewApplyListView.success(patientDetailEntity);
                }
            }

            protected Context attachContext() {
                return PatientNewApplyPresenter.this.mPatientNewApplyListView.injectContext();
            }
        });
    }
}

