/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.PersonInfoBody;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IPersonInfoPresenter;
import com.kangxin.doctor.worktable.view.IPersonInfoView;
import io.reactivex.Observable;
import io.reactivex.Observer;

public class PersonInfoPresenter
implements IPersonInfoPresenter {
    private IPersonInfoView mPersonInfoView;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public PersonInfoPresenter(IPersonInfoView personInfoView) {
        this.mPersonInfoView = personInfoView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void getPersonInfo(boolean isShowLoading) {
        Observable observable = this.mUserModule.getNativeUserInfo(this.mPersonInfoView.injectContext()).flatMap(loginSuccess -> this.mOrderModule.getQueryDoctorDetailsInfo(loginSuccess.getId()));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<PersonInfoBody>>(){

                public void onReqNext(ResponseBody<PersonInfoBody> responseBody) {
                    PersonInfoPresenter.this.mPersonInfoView.getPersonInfo((PersonInfoBody)responseBody.getResult());
                    this.onComplete();
                }

                public void onReqErr(Throwable e) {
                    super.onReqErr(e);
                    PersonInfoPresenter.this.mPersonInfoView.error(e.toString());
                    this.onComplete();
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<PersonInfoBody>>(){

                public void onNext(ResponseBody<PersonInfoBody> responseBody) {
                    PersonInfoPresenter.this.mPersonInfoView.getPersonInfo((PersonInfoBody)responseBody.getResult());
                }

                public void onError(Throwable e) {
                    PersonInfoPresenter.this.mPersonInfoView.error(e.toString());
                }
            });
        }
    }
}

