/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.base.ByBasePresenter;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.DoctorRegisteredInfoListEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IRegisteredInfoListPresenter;
import com.kangxin.doctor.worktable.view.IRegisteredInfoListView;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.List;

public class RegisteredDoctorListInfoPresenter
extends ByBasePresenter
implements IRegisteredInfoListPresenter {
    private IRegisteredInfoListView mOrderListView;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public RegisteredDoctorListInfoPresenter(IRegisteredInfoListView orderListView) {
        this.mOrderListView = orderListView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void getRegisteredInfoList(final boolean isGetMore, boolean isShowLoading) {
        Observable observable = this.mUserModule.getNativeUserInfo(this.mOrderListView.injectContext()).flatMap(loginSuccess -> this.mOrderModule.getRegistrationInfoList(loginSuccess.getId(), this.getPageIndex(isGetMore), this.getPageSize()));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<List<DoctorRegisteredInfoListEntity>>>(){

                public void onReqNext(ResponseBody<List<DoctorRegisteredInfoListEntity>> listResponseBody) {
                    RegisteredDoctorListInfoPresenter.this.fullData(RegisteredDoctorListInfoPresenter.this.mOrderListView, (List)listResponseBody.getResult(), isGetMore);
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    super.onError(e);
                    RegisteredDoctorListInfoPresenter.this.mOrderListView.error(e.toString());
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<List<DoctorRegisteredInfoListEntity>>>(){

                public void onNext(ResponseBody<List<DoctorRegisteredInfoListEntity>> t) {
                    RegisteredDoctorListInfoPresenter.this.fullData(RegisteredDoctorListInfoPresenter.this.mOrderListView, (List)t.getResult(), isGetMore);
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    RegisteredDoctorListInfoPresenter.this.mOrderListView.error(e.toString());
                }
            });
        }
    }
}

