/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.base.ByBasePresenter;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.DoctorRegisteredAllOrderEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IRegisteredDoctorAllOrderListPresenter;
import com.kangxin.doctor.worktable.view.IRegisteredDoctorOrderListView;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.List;

public class RegisteredDoctorOrderListPresenter
extends ByBasePresenter
implements IRegisteredDoctorAllOrderListPresenter {
    private IRegisteredDoctorOrderListView mOrderListView;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public RegisteredDoctorOrderListPresenter(IRegisteredDoctorOrderListView orderListView) {
        this.mOrderListView = orderListView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void getRegisteredOrderList(final boolean isGetMore, long patientInfoId, boolean isShowLoading) {
        Observable observable = this.mUserModule.getNativeUserInfo(this.mOrderListView.injectContext()).flatMap(loginSuccess -> this.mOrderModule.updateDoctorManagerPatientsInfo(loginSuccess.getId(), patientInfoId, this.getPageIndex(isGetMore), this.getPageSize()));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<List<DoctorRegisteredAllOrderEntity>>>(){

                public void onReqNext(ResponseBody<List<DoctorRegisteredAllOrderEntity>> listResponseBody) {
                    RegisteredDoctorOrderListPresenter.this.fullData(RegisteredDoctorOrderListPresenter.this.mOrderListView, (List)listResponseBody.getResult(), isGetMore);
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    super.onError(e);
                    RegisteredDoctorOrderListPresenter.this.mOrderListView.error(e.toString());
                    this.onComplete();
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<List<DoctorRegisteredAllOrderEntity>>>(){

                public void onNext(ResponseBody<List<DoctorRegisteredAllOrderEntity>> t) {
                    RegisteredDoctorOrderListPresenter.this.fullData(RegisteredDoctorOrderListPresenter.this.mOrderListView, (List)t.getResult(), isGetMore);
                }

                public void onError(Throwable e) {
                    RegisteredDoctorOrderListPresenter.this.mOrderListView.error(e.toString());
                }
            });
        }
    }
}

