/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import android.text.TextUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BasePresenter;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.RequestWithdrawCashDataEntity;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.view.IRequestWithdrawCashView;
import io.reactivex.Observable;
import io.reactivex.Observer;

public class RequestWithdrawCashPresenter
extends BasePresenter {
    private IRequestWithdrawCashView mRequestWithdrawCashView;
    private OrderModule mOrderModule;
    private IUserModule mUserModule;

    public RequestWithdrawCashPresenter(IRequestWithdrawCashView requestWithdrawCashView) {
        this.mRequestWithdrawCashView = requestWithdrawCashView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    public void setRequestWithdrawCash(String money, boolean isShowLoading) {
        Context context = this.mRequestWithdrawCashView.injectContext();
        String docId = VertifyDataUtil.getInstance((Context)context).getDoctorId();
        long doctorId = -1L;
        if (!TextUtils.isEmpty((CharSequence)docId)) {
            doctorId = Long.parseLong(docId);
        }
        long finalDoctorId = doctorId;
        Observable observable = this.mUserModule.getNativeUserInfo(context).flatMap(loginSuccess -> this.mOrderModule.sendRequestWithdrawCash(finalDoctorId, money));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<RequestWithdrawCashDataEntity>>(){

                public void onReqNext(ResponseBody<RequestWithdrawCashDataEntity> responseBody) {
                    RequestWithdrawCashPresenter.this.mRequestWithdrawCashView.receiveSuccess(responseBody.getCode(), responseBody.getMsg(), (RequestWithdrawCashDataEntity)responseBody.getResult());
                    this.onComplete();
                }

                public void onReqErr(Throwable e) {
                    super.onReqErr(e);
                    RequestWithdrawCashPresenter.this.mRequestWithdrawCashView.error(e.toString());
                    this.onComplete();
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<RequestWithdrawCashDataEntity>>(){

                public void onNext(ResponseBody<RequestWithdrawCashDataEntity> responseBody) {
                    RequestWithdrawCashPresenter.this.mRequestWithdrawCashView.receiveSuccess(responseBody.getCode(), responseBody.getMsg(), (RequestWithdrawCashDataEntity)responseBody.getResult());
                }

                public void onError(Throwable e) {
                    RequestWithdrawCashPresenter.this.mRequestWithdrawCashView.error(e.toString());
                }
            });
        }
    }
}

