/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.SavePracticeExperiencelEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.ISavePracticeExperiencePresenter;
import com.kangxin.doctor.worktable.view.ISavePracticeExperienceView;
import io.reactivex.Observable;
import io.reactivex.Observer;

public class SavePracticeExperiencePresenter
implements ISavePracticeExperiencePresenter {
    private ISavePracticeExperienceView mSavePracticeExperienceView;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public SavePracticeExperiencePresenter(ISavePracticeExperienceView savePracticeExperienceView) {
        this.mSavePracticeExperienceView = savePracticeExperienceView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void savePracticeExperience(SavePracticeExperiencelEntity savePracticeExperiencel, boolean isShowLoading) {
        Context context = this.mSavePracticeExperienceView.injectContext();
        String docId = VertifyDataUtil.getInstance((Context)context).getDoctorId();
        Observable observable = this.mUserModule.getNativeUserInfo(context).doOnNext(loginSuccess -> savePracticeExperiencel.setDoctorId(docId)).flatMap(loginSuccess -> this.mOrderModule.savePracticeExperiencel(savePracticeExperiencel));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody>(){

                public void onReqNext(ResponseBody responseBody) {
                    if (responseBody == null) {
                        return;
                    }
                    SavePracticeExperiencePresenter.this.mSavePracticeExperienceView.savePracticeExperienceInfoSuccess(responseBody);
                    this.onComplete();
                }

                public void onReqErr(Throwable e) {
                    super.onReqErr(e);
                    SavePracticeExperiencePresenter.this.mSavePracticeExperienceView.error(e.toString());
                    this.onComplete();
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody>(){

                public void onNext(ResponseBody responseBody) {
                    if (responseBody == null) {
                        return;
                    }
                    SavePracticeExperiencePresenter.this.mSavePracticeExperienceView.savePracticeExperienceInfoSuccess(responseBody);
                }

                public void onError(Throwable e) {
                    SavePracticeExperiencePresenter.this.mSavePracticeExperienceView.error(e.toString());
                }
            });
        }
    }
}

