/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.SchedulingManagerCalenderEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IScheduleManagerCalendarPresenter;
import com.kangxin.doctor.worktable.view.ISchedleManagerCalendarView;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.List;

public class ScheduleManagerCalendarPresenter
implements IScheduleManagerCalendarPresenter {
    private ISchedleManagerCalendarView mOrderListView;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public ScheduleManagerCalendarPresenter(ISchedleManagerCalendarView orderListView) {
        this.mOrderListView = orderListView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void getScheduleManagerCalendarList(boolean isShowLoading) {
        Observable observable = this.mUserModule.getNativeUserInfo(this.mOrderListView.injectContext()).flatMap(loginSuccess -> this.mOrderModule.getSchedulingCalenderList(loginSuccess.getId(), VertifyDataUtil.getInstance((Context)this.mOrderListView.injectContext()).getHospitalId()));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<List<SchedulingManagerCalenderEntity>>>(){

                public void onReqNext(ResponseBody<List<SchedulingManagerCalenderEntity>> listResponseBody) {
                    ScheduleManagerCalendarPresenter.this.mOrderListView.getScheduleSuccess((List)listResponseBody.getResult());
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    super.onError(e);
                    ScheduleManagerCalendarPresenter.this.mOrderListView.error(e.toString());
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<List<SchedulingManagerCalenderEntity>>>(){

                public void onNext(ResponseBody<List<SchedulingManagerCalenderEntity>> t) {
                    ScheduleManagerCalendarPresenter.this.mOrderListView.getScheduleSuccess((List)t.getResult());
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    ScheduleManagerCalendarPresenter.this.mOrderListView.error(e.toString());
                }
            });
        }
    }
}

