/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.base.ByBasePresenter;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.ScheduleManagerOrgerListEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IScheduleManagerOrderListPresenter;
import com.kangxin.doctor.worktable.view.IScheduleManagerOrderListView;
import io.reactivex.Observable;
import io.reactivex.Observer;

public class ScheduleManagerOrderListPresenter
extends ByBasePresenter
implements IScheduleManagerOrderListPresenter {
    private IScheduleManagerOrderListView mOrderListView;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public ScheduleManagerOrderListPresenter(IScheduleManagerOrderListView orderListView) {
        this.mOrderListView = orderListView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void getSchedulingOrderList(final boolean isGetMore, boolean isShowLoading) {
        Observable observable = this.mUserModule.getNativeUserInfo(this.mOrderListView.injectContext()).flatMap(loginSuccess -> this.mOrderModule.getSchedulingOrderList(loginSuccess.getId(), this.getPageIndex(isGetMore), this.getPageSize()));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<ScheduleManagerOrgerListEntity>>(){

                public void onReqNext(ResponseBody<ScheduleManagerOrgerListEntity> listResponseBody) {
                    ScheduleManagerOrderListPresenter.this.fullData(ScheduleManagerOrderListPresenter.this.mOrderListView, ((ScheduleManagerOrgerListEntity)listResponseBody.getResult()).getPageData(), isGetMore);
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    super.onError(e);
                    ScheduleManagerOrderListPresenter.this.mOrderListView.error(e.toString());
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<ScheduleManagerOrgerListEntity>>(){

                public void onNext(ResponseBody<ScheduleManagerOrgerListEntity> t) {
                    ScheduleManagerOrderListPresenter.this.fullData(ScheduleManagerOrderListPresenter.this.mOrderListView, ((ScheduleManagerOrgerListEntity)t.getResult()).getPageData(), isGetMore);
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    ScheduleManagerOrderListPresenter.this.mOrderListView.error(e.toString());
                }
            });
        }
    }
}

