/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.base.ByBasePresenter;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.ServiceSettingHospitalDetailsListEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IServiceSettingInfoDetailsPresenter;
import com.kangxin.doctor.worktable.view.IServiceSettingInfoDetailsView;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.List;

public class ServiceSettingDetailsListPresenter
extends ByBasePresenter
implements IServiceSettingInfoDetailsPresenter {
    private IServiceSettingInfoDetailsView mDetailsView;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public ServiceSettingDetailsListPresenter(IServiceSettingInfoDetailsView detailsView) {
        this.mDetailsView = detailsView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void getServiceSettingDetailsInfo(final boolean isGetMore, int groupCode, boolean isShowLoading) {
        Observable observable = this.mUserModule.getNativeUserInfo(this.mDetailsView.injectContext()).flatMap(loginSuccess -> this.mOrderModule.getServiceSettingHospitalDetailsList(loginSuccess.getId(), groupCode));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<List<ServiceSettingHospitalDetailsListEntity>>>(){

                public void onReqNext(ResponseBody<List<ServiceSettingHospitalDetailsListEntity>> listResponseBody) {
                    ServiceSettingDetailsListPresenter.this.fullData(ServiceSettingDetailsListPresenter.this.mDetailsView, (List)listResponseBody.getResult(), isGetMore);
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    super.onError(e);
                    ServiceSettingDetailsListPresenter.this.mDetailsView.error(e.toString());
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<List<ServiceSettingHospitalDetailsListEntity>>>(){

                public void onNext(ResponseBody<List<ServiceSettingHospitalDetailsListEntity>> t) {
                    ServiceSettingDetailsListPresenter.this.fullData(ServiceSettingDetailsListPresenter.this.mDetailsView, (List)t.getResult(), isGetMore);
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    ServiceSettingDetailsListPresenter.this.mDetailsView.error(e.toString());
                }
            });
        }
    }
}

