/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BasePresenter;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.ServiceSettingHospitalEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IServiceSettingInfoPresenter;
import com.kangxin.doctor.worktable.view.IServiceSettingInfoView;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.List;

public class ServiceSettingInfoPresenter
extends BasePresenter
implements IServiceSettingInfoPresenter {
    private static final String TAG = "ServiceSettingInfoPrese";
    private IServiceSettingInfoView mIServiceSettingInfoView;
    private IOrderModule mIOrderModule;
    private IUserModule mUserModule;

    public ServiceSettingInfoPresenter(IServiceSettingInfoView iServiceSettingInfoView) {
        this.mIServiceSettingInfoView = iServiceSettingInfoView;
        this.mIOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void sendRequestServiceHospitalInfo() {
        String organId = VertifyDataUtil.getInstance((Context)this.mContext).getOrganId();
        String docId = VertifyDataUtil.getInstance((Context)this.mContext).getDoctorId();
        Observable observable = this.mUserModule.getNativeUserInfo(this.mIServiceSettingInfoView.injectContext()).flatMap(loginSuccess -> this.mIOrderModule.getServiceSettingHospitalList(docId, organId));
        observable.subscribe((Observer)new RxProgressObserver<ResponseBody<List<ServiceSettingHospitalEntity>>>(){

            public void onReqNext(ResponseBody<List<ServiceSettingHospitalEntity>> responseBody) {
                ServiceSettingInfoPresenter.this.mIServiceSettingInfoView.receiveServiceHospitalEntity((List)responseBody.getResult());
                this.onComplete();
            }

            public void onError(Throwable e) {
                super.onError(e);
                ServiceSettingInfoPresenter.this.mIServiceSettingInfoView.error(e.toString());
            }
        });
    }
}

