/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.StandardSecondDepartmentEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IStandardSecondDepartmentListPresenter;
import com.kangxin.doctor.worktable.view.IStandardSecondDepartmentListView;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.List;

public class StandardSecondDepartmentListPresenter
implements IStandardSecondDepartmentListPresenter {
    private IStandardSecondDepartmentListView mSecondDepartmentListView;
    private IOrderModule mOrderModule;

    public StandardSecondDepartmentListPresenter(IStandardSecondDepartmentListView secondDepartmentListView) {
        this.mSecondDepartmentListView = secondDepartmentListView;
        this.mOrderModule = new OrderModule();
    }

    @Override
    public void getStandardSecondDepartmentList(boolean isShowLoading) {
        Observable<ResponseBody<List<StandardSecondDepartmentEntity>>> observable = this.mOrderModule.getStandardSecondDepartmentList();
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<List<StandardSecondDepartmentEntity>>>(){

                public void onReqNext(ResponseBody<List<StandardSecondDepartmentEntity>> responseBody) {
                    if (responseBody == null) {
                        return;
                    }
                    StandardSecondDepartmentListPresenter.this.mSecondDepartmentListView.getStandardSecondDepartmentListSuccess((List)responseBody.getResult());
                    this.onComplete();
                }

                public void onReqErr(Throwable e) {
                    super.onReqErr(e);
                    StandardSecondDepartmentListPresenter.this.mSecondDepartmentListView.error(e.toString());
                    this.onComplete();
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<List<StandardSecondDepartmentEntity>>>(){

                public void onNext(ResponseBody<List<StandardSecondDepartmentEntity>> responseBody) {
                    if (responseBody == null) {
                        return;
                    }
                    StandardSecondDepartmentListPresenter.this.mSecondDepartmentListView.getStandardSecondDepartmentListSuccess((List)responseBody.getResult());
                }

                public void onError(Throwable e) {
                    StandardSecondDepartmentListPresenter.this.mSecondDepartmentListView.error(e.toString());
                }
            });
        }
    }
}

