/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.RxBaseObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IUpdateHeadImagePresenter;
import com.kangxin.doctor.worktable.view.IUpdateHeadImageView;
import io.reactivex.Observer;

public class UpdateHeadImagePresenter
implements IUpdateHeadImagePresenter {
    private IUpdateHeadImageView mUpdateHeadImageView;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public UpdateHeadImagePresenter(IUpdateHeadImageView updateHeadImageView) {
        this.mUpdateHeadImageView = updateHeadImageView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void updateHeadImage(Context context, String headImageUrl, boolean isShowLoading) {
        String token = VertifyDataUtil.getInstance((Context)context).getToken();
        String accountNo = VertifyDataUtil.getInstance((Context)context).getLoginData().getMobileNumber();
        ReqWebBody reqWebBody = new ReqWebBody();
        reqWebBody.setHeadImageUrl(headImageUrl);
        reqWebBody.setAccountNo(accountNo);
        if (isShowLoading) {
            this.mOrderModule.updateHeadImage(token, reqWebBody).subscribe((Observer)new RxProgressObserver<ResponseBody>(){

                public void onReqNext(ResponseBody responseBody) {
                    UpdateHeadImagePresenter.this.mUpdateHeadImageView.updateHeadImageOk(responseBody);
                }
            });
        } else {
            this.mOrderModule.updateHeadImage(token, reqWebBody).subscribe((Observer)new RxBaseObserver<ResponseBody>(){

                public void onReqNext(ResponseBody responseBody) {
                    UpdateHeadImagePresenter.this.mUpdateHeadImageView.updateHeadImageOk(responseBody);
                }

                public void onError(Throwable e) {
                }

                public void onComplete() {
                }
            });
        }
    }
}

