/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.doctor.worktable.entity.TodayWorkEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IWorkTablePresenter;
import com.kangxin.doctor.worktable.view.IWorkTableView;
import io.reactivex.Observer;

public class WorkTablePresenter
implements IWorkTablePresenter {
    private IWorkTableView mWorkTableView;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public WorkTablePresenter(IWorkTableView view) {
        this.mWorkTableView = view;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void getTodayWorkInfo() {
        LoginSuccess loginData = VertifyDataUtil.getInstance((Context)this.mWorkTableView.injectContext()).getLoginData();
        if (loginData == null) {
            return;
        }
        this.mUserModule.getNativeUserInfo(this.mWorkTableView.injectContext()).flatMap(loginSuccess -> this.mOrderModule.getTodayWorkInfo(loginSuccess.getId())).subscribe((Observer)new ProgressDialogObserver<ResponseBody<TodayWorkEntity>>(){

            public void onNext(ResponseBody<TodayWorkEntity> responseBody) {
                if (responseBody.getCode() == 200) {
                    TodayWorkEntity result = (TodayWorkEntity)responseBody.getResult();
                    WorkTablePresenter.this.mWorkTableView.fullWorkInfo(result.getApplyCount(), 0, result.getTodayConsultionCount());
                    this.onComplete();
                }
            }

            protected Context attachContext() {
                return WorkTablePresenter.this.mWorkTableView.injectContext();
            }
        });
    }

    @Override
    public void getTodaySubscribeInfo() {
        LoginSuccess loginData = VertifyDataUtil.getInstance((Context)this.mWorkTableView.injectContext()).getLoginData();
        if (loginData == null) {
            return;
        }
        this.mUserModule.getNativeUserInfo(this.mWorkTableView.injectContext()).flatMap(loginSuccess -> this.mOrderModule.getTodaySubscribeInfo(loginSuccess.getId())).subscribe((Observer)new ProgressDialogObserver<ResponseBody<Integer>>(){

            public void onNext(ResponseBody<Integer> responseBody) {
                if (responseBody.getCode() == 200) {
                    if (responseBody.getResult() != null) {
                        WorkTablePresenter.this.mWorkTableView.fullSubscribeWorkInfo((Integer)responseBody.getResult());
                    }
                    this.onComplete();
                }
            }

            protected Context attachContext() {
                return WorkTablePresenter.this.mWorkTableView.injectContext();
            }
        });
    }
}

