/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl2;

import android.content.Context;
import com.blankj.utilcode.util.RegexUtils;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.PatientEntity;
import com.kangxin.common.byh.entity.PatientSaveSuccessEntity;
import com.kangxin.common.byh.entity.VertifyIDCardEntity;
import com.kangxin.common.byh.entity.v2.PatientEntityV2;
import com.kangxin.common.byh.module.IPatientModule;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.bh.BHPatientModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.util.VerifyUtil;
import com.kangxin.common.widget.ProgressDialogObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.presenter.IAddPatientPresenter;
import com.kangxin.doctor.worktable.view.IAddPatientView;
import io.reactivex.Observer;
import org.greenrobot.eventbus.EventBus;

public class BHAddPatientPresenter
implements IAddPatientPresenter {
    private IAddPatientView mAddPatientView;
    private IPatientModule mPatientModule;
    private IUserModule mUserModule;

    public BHAddPatientPresenter(IAddPatientView mAddPatientView) {
        this.mAddPatientView = mAddPatientView;
        this.mPatientModule = new BHPatientModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void savePatient(final PatientEntity patientEntity) {
        if (!RegexUtils.isMobileSimple((CharSequence)patientEntity.getMobileNumber())) {
            ToastUtils.showShort((CharSequence)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7535\u8bdd\u53f7");
            return;
        }
        if (!RegexUtils.isIDCard18((CharSequence)patientEntity.getIdCard())) {
            ToastUtils.showShort((CharSequence)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8eab\u4efd\u8bc1\u53f7");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)patientEntity.getName()) || patientEntity.getGender() == 0) {
            ToastUtils.showShort((CharSequence)"\u60a3\u8005\u59d3\u540d\uff0c\u6027\u522b\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        String idcardNo = patientEntity.getIdCard();
        idcardNo = VerifyUtil.changeIdcard((String)idcardNo);
        this.mUserModule.vertifyUserIdCard(idcardNo, patientEntity.getName()).filter(responseBody -> {
            Integer code = ((VertifyIDCardEntity)responseBody.getResult()).getCode();
            if (code == 200) {
                return true;
            }
            this.mAddPatientView.error("\u8eab\u4efd\u8bc1\u53f7\u7801\u548c\u59d3\u540d\u4e0d\u4e00\u81f4");
            return false;
        }).flatMap(responseBody -> this.mUserModule.getNativeUserInfo(this.mAddPatientView.injectContext())).flatMap(loginSuccess -> this.mPatientModule.savePatientInfo(patientEntity)).subscribe((Observer)new RxProgressObserver<ResponseBody<PatientSaveSuccessEntity>>(){

            public void onNext(ResponseBody<PatientSaveSuccessEntity> patientSaveSuccessEntityResponseBody) {
                if (patientSaveSuccessEntityResponseBody.getCode() == 200) {
                    PatientSaveSuccessEntity patient2 = (PatientSaveSuccessEntity)patientSaveSuccessEntityResponseBody.getResult();
                    if (patient2 != null) {
                        patient2.setMobileNumber(patientEntity.getMobileNumber());
                        PatientEntity result = (PatientEntity)patientSaveSuccessEntityResponseBody.getResult();
                        EventBus.getDefault().post((Object)result);
                        BHAddPatientPresenter.this.mAddPatientView.finish();
                    } else {
                        ToastUtils.showShort((CharSequence)(patientSaveSuccessEntityResponseBody.getMsg() + ""));
                    }
                    this.onComplete();
                } else {
                    ToastUtils.showShort((CharSequence)(patientSaveSuccessEntityResponseBody.getMsg() + ""));
                }
            }

            public void onReqNext(ResponseBody<PatientSaveSuccessEntity> patientSaveSuccessEntityResponseBody) {
                BHAddPatientPresenter.this.mAddPatientView.error(patientSaveSuccessEntityResponseBody.getMsg());
                this.onComplete();
            }
        });
    }

    @Override
    public void savePatientV2(final PatientEntity patientEntity) {
        final PatientEntityV2 entityV2 = PatientEntityV2.parse((PatientEntity)patientEntity);
        if (!RegexUtils.isMobileSimple((CharSequence)patientEntity.getMobileNumber())) {
            ToastUtils.showShort((CharSequence)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7535\u8bdd\u53f7");
            return;
        }
        if (!RegexUtils.isIDCard18((CharSequence)patientEntity.getIdCard())) {
            ToastUtils.showShort((CharSequence)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8eab\u4efd\u8bc1\u53f7");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)patientEntity.getName()) || patientEntity.getGender() == 0) {
            ToastUtils.showShort((CharSequence)"\u60a3\u8005\u59d3\u540d\uff0c\u6027\u522b\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        String idcardNo = patientEntity.getIdCard();
        idcardNo = VerifyUtil.changeIdcard((String)idcardNo);
        this.mUserModule.vertifyUserIdCard(idcardNo, patientEntity.getName()).filter(responseBody -> {
            Integer code = ((VertifyIDCardEntity)responseBody.getResult()).getCode();
            if (code == 0) {
                return true;
            }
            this.mAddPatientView.error(((VertifyIDCardEntity)responseBody.getResult()).getMsg());
            return false;
        }).flatMap(vertifyIDCardEntityResponseBody -> this.mPatientModule.savePatientInfoV2(entityV2)).subscribe((Observer)new ProgressDialogObserver<ResponseBody<String>>(){

            public void onNext(ResponseBody<String> responseBody) {
                String patientId = (String)responseBody.getData();
                if (responseBody.getCode() == 200) {
                    if (patientEntity != null) {
                        patientEntity.setViewId(patientId);
                        if (patientId != null) {
                            patientEntity.setId(Long.parseLong(patientId));
                            patientEntity.setPatId(Long.parseLong(patientId));
                        }
                        patientEntity.setBrithYearMonthDay(entityV2.getBirthdate());
                        EventBus.getDefault().postSticky((Object)patientEntity);
                        BHAddPatientPresenter.this.mAddPatientView.finish();
                    } else {
                        ToastUtils.showShort((CharSequence)(responseBody.getMsg() + ""));
                    }
                } else {
                    ToastUtils.showShort((CharSequence)(responseBody.getMsg() + ""));
                }
                this.onComplete();
            }

            protected Context attachContext() {
                return BHAddPatientPresenter.this.mAddPatientView.injectContext();
            }
        });
    }
}

