/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl2;

import android.content.Context;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.OrderApplyEntity;
import com.kangxin.common.byh.entity.UpdateCaseEntity;
import com.kangxin.common.byh.entity.response.UpImgEntity;
import com.kangxin.common.byh.module.IFileModule;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UpFileModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.present.IOrderApplyPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.util.SchedulesSwitch;
import com.kangxin.doctor.worktable.BuildConfig;
import com.kangxin.doctor.worktable.entity.OrderApplySuccessEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl2.BHOrderModule;
import com.kangxin.doctor.worktable.view.IOrderApplyView;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import java.util.ArrayList;
import java.util.List;

@Route(path="/order_service/order")
public class BHOrderApplyPresenter
implements IOrderApplyPresenter {
    private IUserModule mUserModule;
    private IOrderApplyView mOrderApplyView;
    private IOrderModule mOrderModule;
    private IFileModule mFileModule;
    private boolean isMustUploadCaseFile = BuildConfig.isMustUploadCaseFile;

    public BHOrderApplyPresenter(IOrderApplyView mOrderApplyView) {
        this.mOrderApplyView = mOrderApplyView;
        this.mUserModule = new UserModule();
        this.mOrderModule = new BHOrderModule();
        this.mFileModule = new UpFileModule();
    }

    public void applyOrder(OrderApplyEntity orderApplyEntity, List<String> data, final List<Integer> ids) {
        boolean flag = false;
        orderApplyEntity.setDoctorId(Long.valueOf(Long.parseLong(VertifyDataUtil.getInstance((Context)this.mOrderApplyView.injectContext()).getDoctorId())));
        if (flag) {
            this.mOrderModule.newApplyOrder(orderApplyEntity).filter(responseBody -> {
                System.out.print(responseBody.toString());
                if (responseBody.getCode() == 200 && responseBody.getResult() != null) {
                    return true;
                }
                this.mOrderApplyView.error(responseBody.getMsg());
                return false;
            }).map(ResponseBody::getData).subscribe((Observer)new SampleObserver<OrderApplySuccessEntity>(){

                public void onNext(OrderApplySuccessEntity successEntity) {
                    System.out.println(successEntity.toString());
                    BHOrderApplyPresenter.this.mOrderApplyView.toSign(successEntity.getId(), successEntity.getViewId(), successEntity.getDoctorHosName(), successEntity.getApplicationChannels(), successEntity.getInitiatorType());
                }
            });
        } else {
            Integer deptId;
            ArrayList<String> nativeImages = new ArrayList<String>();
            for (String temp : data) {
                if (temp.equals("") || temp.startsWith("http:/")) continue;
                nativeImages.add(temp);
            }
            if (orderApplyEntity.getApplicationChannels() == 30 && (deptId = orderApplyEntity.getDeptId()) == null) {
                ToastUtils.showShort((CharSequence)"\u8bf7\u9009\u62e9\u79d1\u5ba4");
                return;
            }
            if (orderApplyEntity.getType() == 0) {
                ToastUtils.showShort((CharSequence)"\u8bf7\u9009\u62e9\u4f1a\u8bca\u7c7b\u578b");
                return;
            }
            if (this.isMustUploadCaseFile && nativeImages.size() == 0 && ids.size() == 0) {
                ToastUtils.showShort((CharSequence)"\u75c5\u4f8b\u9644\u4ef6\u9700\u8981\u4e0a\u4f20");
                return;
            }
            if (nativeImages.size() > 0) {
                this.mFileModule.uploadFiles(nativeImages).filter(listResponseBody -> {
                    if (listResponseBody.getCode() == 200) {
                        return true;
                    }
                    ToastUtils.showShort((CharSequence)"\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    return false;
                }).map(listResponseBody -> {
                    List result = (List)listResponseBody.getResult();
                    ArrayList<Integer> integers = new ArrayList<Integer>();
                    for (UpImgEntity x : result) {
                        integers.add(x.getId());
                    }
                    integers.addAll(ids);
                    return integers;
                }).doOnNext(integers -> orderApplyEntity.setOssFileIds(integers)).flatMap(listResponseBody -> {
                    Context context = this.mOrderApplyView.injectContext();
                    Observable nativeUserInfo = this.mUserModule.getNativeUserInfo(context);
                    return nativeUserInfo;
                }).filter(loginSuccess -> {
                    if (loginSuccess != null) {
                        return true;
                    }
                    ToastUtils.showShort((CharSequence)"\u672c\u5730\u6570\u636e\u5f02\u5e38\uff0c\u9000\u51fa\u767b\u5f55\u91cd\u8bd5");
                    return false;
                }).map(loginSuccess -> orderApplyEntity).flatMap(orderApplyEntity1 -> {
                    if (orderApplyEntity1.getOrderId() != null) {
                        return this.mOrderModule.updateOrder((OrderApplyEntity)orderApplyEntity1).compose(SchedulesSwitch.applySchedulers());
                    }
                    return this.mOrderModule.newApplyOrder((OrderApplyEntity)orderApplyEntity1).compose(SchedulesSwitch.applySchedulers());
                }).filter(responseBody -> {
                    if (responseBody.getCode() == 200 && responseBody.getResult() != null) {
                        return true;
                    }
                    this.mOrderApplyView.error(responseBody.getMsg());
                    return false;
                }).map(ResponseBody::getResult).subscribe((Observer)new ProgressDialogObserver<OrderApplySuccessEntity>(){

                    public void onNext(OrderApplySuccessEntity successEntity) {
                        this.onComplete();
                        BHOrderApplyPresenter.this.mOrderApplyView.toSign(successEntity.getId(), successEntity.getViewId(), successEntity.getDoctorHosName(), successEntity.getApplicationChannels(), successEntity.getInitiatorType());
                    }

                    protected Context attachContext() {
                        return BHOrderApplyPresenter.this.mOrderApplyView.injectContext();
                    }
                });
            } else {
                Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<List<Integer>>(){

                    public void subscribe(ObservableEmitter<List<Integer>> emitter) throws Exception {
                        emitter.onNext((Object)ids);
                    }
                }).doOnNext(integers -> orderApplyEntity.setOssFileIds(integers)).flatMap(listResponseBody -> {
                    Context context = this.mOrderApplyView.injectContext();
                    Observable nativeUserInfo = this.mUserModule.getNativeUserInfo(context);
                    return nativeUserInfo;
                }).filter(loginSuccess -> {
                    if (loginSuccess != null) {
                        return true;
                    }
                    ToastUtils.showShort((CharSequence)"\u672c\u5730\u6570\u636e\u5f02\u5e38\uff0c\u9000\u51fa\u767b\u5f55\u91cd\u8bd5");
                    return false;
                }).doOnNext(loginSuccess -> {}).map(loginSuccess -> orderApplyEntity).flatMap(orderApplyEntity1 -> {
                    if (orderApplyEntity1.getOrderId() != null) {
                        return this.mOrderModule.updateOrder((OrderApplyEntity)orderApplyEntity1).compose(SchedulesSwitch.applySchedulers());
                    }
                    return this.mOrderModule.newApplyOrder((OrderApplyEntity)orderApplyEntity1).compose(SchedulesSwitch.applySchedulers());
                }).filter(responseBody -> {
                    if (responseBody.getCode() == 200 && responseBody.getResult() != null) {
                        return true;
                    }
                    this.mOrderApplyView.error(responseBody.getMsg());
                    return false;
                }).map(ResponseBody::getResult).subscribe((Observer)new ProgressDialogObserver<OrderApplySuccessEntity>(){

                    public void onNext(OrderApplySuccessEntity successEntity) {
                        this.onComplete();
                        BHOrderApplyPresenter.this.mOrderApplyView.toSign(successEntity.getId(), successEntity.getViewId(), successEntity.getDoctorHosName(), successEntity.getApplicationChannels(), successEntity.getInitiatorType());
                    }

                    protected Context attachContext() {
                        return BHOrderApplyPresenter.this.mOrderApplyView.injectContext();
                    }
                });
            }
        }
    }

    public void updateOrderCase(UpdateCaseEntity caseEntity, List<String> data, List<Integer> ids) {
        ArrayList<String> nativeImages = new ArrayList<String>();
        for (String temp : data) {
            if (temp.equals("") || temp.startsWith("http:/")) continue;
            nativeImages.add(temp);
        }
        if (this.isMustUploadCaseFile && nativeImages.size() == 0 && ids.size() == 0) {
            ToastUtils.showShort((CharSequence)"\u75c5\u4f8b\u9644\u4ef6\u9700\u8981\u4e0a\u4f20");
            return;
        }
        if (nativeImages.size() > 0) {
            this.mFileModule.uploadFiles(nativeImages).doOnNext(listResponseBody -> {
                for (int i = 0; i < ((List)listResponseBody.getResult()).size(); ++i) {
                    ids.add(((UpImgEntity)((List)listResponseBody.getResult()).get(i)).getId());
                }
                caseEntity.setOssFileIds(ids);
            }).flatMap(listResponseBody -> this.mOrderModule.updateCase(caseEntity)).subscribe((Observer)new ProgressDialogObserver<ResponseBody<OrderApplySuccessEntity>>(){

                public void onNext(ResponseBody<OrderApplySuccessEntity> orderApplySuccessEntityResponseBody) {
                    if (orderApplySuccessEntityResponseBody.getCode() == 200) {
                        OrderApplySuccessEntity successEntity = (OrderApplySuccessEntity)orderApplySuccessEntityResponseBody.getResult();
                        this.onComplete();
                        BHOrderApplyPresenter.this.mOrderApplyView.toPatientCaseViewAndUpdate();
                    } else {
                        BHOrderApplyPresenter.this.mOrderApplyView.error(orderApplySuccessEntityResponseBody.getMsg());
                    }
                }

                protected Context attachContext() {
                    return BHOrderApplyPresenter.this.mOrderApplyView.injectContext();
                }
            });
        } else {
            caseEntity.setOssFileIds(ids);
            this.mOrderModule.updateCase(caseEntity).subscribe((Observer)new ProgressDialogObserver<ResponseBody<OrderApplySuccessEntity>>(){

                public void onNext(ResponseBody<OrderApplySuccessEntity> orderApplySuccessEntityResponseBody) {
                    if (orderApplySuccessEntityResponseBody.getCode() == 200) {
                        OrderApplySuccessEntity successEntity = (OrderApplySuccessEntity)orderApplySuccessEntityResponseBody.getResult();
                        this.onComplete();
                        BHOrderApplyPresenter.this.mOrderApplyView.toPatientCaseViewAndUpdate();
                    } else {
                        BHOrderApplyPresenter.this.mOrderApplyView.error(orderApplySuccessEntityResponseBody.getMsg());
                    }
                }

                protected Context attachContext() {
                    return BHOrderApplyPresenter.this.mOrderApplyView.injectContext();
                }
            });
        }
    }

    public void init(Context context) {
    }
}

