/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl2;

import android.annotation.SuppressLint;
import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl2.BHOrderModule;
import com.kangxin.doctor.worktable.presenter.impl.OrderApplySignPresenter;
import com.kangxin.doctor.worktable.view.IOrderApplySignView;
import io.reactivex.Observer;

public class BHOrderApplySignPresenter
extends OrderApplySignPresenter {
    private IOrderModule orderModule;
    private IOrderApplySignView orderApplySignView;

    public BHOrderApplySignPresenter(IOrderApplySignView orderApplySignView) {
        this.orderApplySignView = orderApplySignView;
        this.orderModule = new BHOrderModule();
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void uploadSign(String orderId, String mSignUrl, String mTag) {
        if (mTag == null || mTag.equals("")) {
            this.orderModule.uploadPatientSign(orderId, mSignUrl).subscribe((Observer)new ProgressDialogObserver<ResponseBody>(){

                public void onNext(ResponseBody responseBody) {
                    if (responseBody.getCode() == 200) {
                        BHOrderApplySignPresenter.this.orderApplySignView.success();
                    } else {
                        BHOrderApplySignPresenter.this.orderApplySignView.error(responseBody.getMsg());
                    }
                }

                protected Context attachContext() {
                    return BHOrderApplySignPresenter.this.orderApplySignView.injectContext();
                }
            });
        } else {
            this.orderModule.uploadPatientSign(orderId, mSignUrl, mTag).subscribe((Observer)new ProgressDialogObserver<ResponseBody>(){

                public void onNext(ResponseBody responseBody) {
                    if (responseBody.getCode() == 200) {
                        BHOrderApplySignPresenter.this.orderApplySignView.success();
                    } else {
                        BHOrderApplySignPresenter.this.orderApplySignView.error(responseBody.getMsg() + "");
                    }
                    this.onComplete();
                }

                protected Context attachContext() {
                    return BHOrderApplySignPresenter.this.orderApplySignView.injectContext();
                }
            });
        }
    }

    @Override
    public void getShareUrl() {
        String openCode = VertifyDataUtil.getInstance((Context)this.orderApplySignView.injectContext()).getOpenCode();
        this.orderModule.getSignShareUrl(openCode).subscribe((Observer)new SampleObserver<ResponseBody<String>>(){

            public void onNext(ResponseBody<String> t) {
                String result = (String)t.getResult();
                BHOrderApplySignPresenter.this.orderApplySignView.toShare(result);
            }
        });
    }
}

