/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl2;

import android.content.Context;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.google.gson.Gson;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.present.IOrderDetailPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.doctor.worktable.entity.v2.DicomEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl2.BHOrderModule;
import com.kangxin.doctor.worktable.view.IOrderDetailView;
import io.reactivex.Observer;
import java.util.Arrays;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

@Route(path="/order_service/order_detail")
public class BHOrderDetailPresenter
implements IOrderDetailPresenter {
    private IOrderDetailView orderDetailView;
    private IOrderModule orderModule;
    Context context;

    public BHOrderDetailPresenter(IOrderDetailView orderDetailView) {
        this.orderDetailView = orderDetailView;
        this.orderModule = new BHOrderModule();
    }

    public BHOrderDetailPresenter() {
        this.orderModule = new BHOrderModule();
    }

    public void getOrderDetail(String orderViewId) {
        this.orderModule.getOrderDetail(orderViewId).subscribe((Observer)new ProgressDialogObserver<ResponseBody<OrderDetailEntity>>(){

            public void onNext(ResponseBody<OrderDetailEntity> responseBody) {
                OrderDetailEntity data;
                if (responseBody.getCode() == 200 && (data = (OrderDetailEntity)responseBody.getData()) != null) {
                    if (BHOrderDetailPresenter.this.orderDetailView != null) {
                        BHOrderDetailPresenter.this.orderDetailView.bindOrderDetail(data);
                    }
                    EventBus.getDefault().post((Object)data);
                }
            }

            protected Context attachContext() {
                if (BHOrderDetailPresenter.this.orderDetailView == null) {
                    return BHOrderDetailPresenter.this.context;
                }
                return BHOrderDetailPresenter.this.orderDetailView.injectContext();
            }
        });
    }

    public void cancleOrder(String orderId, String cancleReason) {
        String closeId = VertifyDataUtil.getInstance((Context)this.orderDetailView.injectContext()).getDoctorId();
        this.orderModule.cancleOrder(orderId, closeId, "3", cancleReason).subscribe((Observer)new ProgressDialogObserver<ResponseBody>(){

            public void onNext(ResponseBody responseBody) {
                if (responseBody.getCode() == 200) {
                    ToastUtils.showShort((CharSequence)"\u5f88\u62b1\u6b49\uff0c\u4f1a\u8bca\u8ba2\u5355\u5df2\u53d6\u6d88");
                    BHOrderDetailPresenter.this.orderDetailView.cancleSuccess();
                    return;
                }
                ToastUtils.showShort((CharSequence)(responseBody.getMsg() + ""));
            }

            protected Context attachContext() {
                if (BHOrderDetailPresenter.this.orderDetailView == null) {
                    return BHOrderDetailPresenter.this.context;
                }
                return BHOrderDetailPresenter.this.orderDetailView.injectContext();
            }
        });
    }

    public void getDicomInfo(String dcmPackUrl) {
        if (StringUtils.isEmpty((CharSequence)dcmPackUrl)) {
            ToastUtils.showShort((CharSequence)"\u6682\u65e0dicom\u6587\u6863");
            return;
        }
        DicomEntity[] dicomEntities = (DicomEntity[])new Gson().fromJson(dcmPackUrl, DicomEntity[].class);
        List<DicomEntity> results = Arrays.asList(dicomEntities);
        String stuuids = "";
        if (results != null) {
            for (DicomEntity entity : results) {
                stuuids = stuuids + entity.getStuuid() + ",";
            }
            stuuids = stuuids.substring(0, stuuids.length() - 1);
        }
        this.orderModule.getDicomShareUrl("36000", stuuids).subscribe((Observer)new ProgressDialogObserver<ResponseBody<String>>(){

            public void onNext(ResponseBody<String> responseBody) {
                if (responseBody != null && responseBody.getCode() == 200) {
                    BHOrderDetailPresenter.this.orderDetailView.toDicom("dicom\u6587\u4ef6", (String)responseBody.getResult());
                } else {
                    ToastUtils.showShort((CharSequence)"\u670d\u52a1\u5668\u9519\u8bef");
                }
            }

            protected Context attachContext() {
                if (BHOrderDetailPresenter.this.orderDetailView == null) {
                    return BHOrderDetailPresenter.this.context;
                }
                return BHOrderDetailPresenter.this.orderDetailView.injectContext();
            }
        });
    }

    public void init(Context context) {
        this.context = context;
    }
}

