/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl2;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.response.UpImgEntity;
import com.kangxin.common.byh.entity.v2.PatientRelationEntityV2;
import com.kangxin.common.byh.module.IFileModule;
import com.kangxin.common.byh.module.IGlobalModule;
import com.kangxin.common.byh.module.bh.BHGlobalModule;
import com.kangxin.common.byh.module.impl.UpFileModule;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IPatientSignPresenter;
import com.kangxin.doctor.worktable.view.IPatientSignView;
import io.reactivex.Observer;
import java.util.List;

public class BHPatientSignPresenter
implements IPatientSignPresenter {
    private IPatientSignView mPatientSignView;
    private IGlobalModule mPatientSignModule;
    private IOrderModule mOrderModule;
    private IFileModule mFileModule;

    public BHPatientSignPresenter(IPatientSignView mPatientSignView) {
        this.mPatientSignView = mPatientSignView;
        this.mPatientSignModule = new BHGlobalModule();
        this.mOrderModule = new OrderModule();
        this.mFileModule = new UpFileModule();
    }

    @Override
    public void getRelationShip() {
        this.mPatientSignModule.getPatientRelationEntityV2().filter(dataArrayEntityResponseBody -> {
            if (dataArrayEntityResponseBody.getCode() == 200) {
                return true;
            }
            this.mPatientSignView.error(dataArrayEntityResponseBody.getMsg());
            return false;
        }).doOnNext(dataArrayEntityResponseBody -> {
            if (dataArrayEntityResponseBody.getResult() != null) {
                this.mPatientSignView.bindData((List)dataArrayEntityResponseBody.getResult());
            } else {
                this.mPatientSignView.error(dataArrayEntityResponseBody.getMsg());
            }
        }).subscribe((Observer)new SampleObserver<ResponseBody<List<PatientRelationEntityV2>>>(){

            public void onNext(ResponseBody<List<PatientRelationEntityV2>> t) {
            }
        });
    }

    @Override
    public void uploadPatientWriteSign(String mOrderId, String signUrl, String tag) {
        this.mFileModule.uploadFile(signUrl).filter(responseBody -> {
            if (responseBody.getCode() == 200) {
                return true;
            }
            this.mPatientSignView.error(responseBody.getMsg());
            return false;
        }).doOnNext(upImgEntityResponseBody -> this.mPatientSignView.saveSuccess(((UpImgEntity)upImgEntityResponseBody.getResult()).getUrl(), tag)).subscribe((Observer)new ProgressDialogObserver<ResponseBody<UpImgEntity>>(){

            public void onNext(ResponseBody<UpImgEntity> upImgEntityResponseBody) {
            }

            protected Context attachContext() {
                return BHPatientSignPresenter.this.mPatientSignView.injectContext();
            }
        });
    }
}

