/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl2;

import android.content.Context;
import com.blankj.utilcode.util.StringUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.doctor.worktable.entity.v2.ConsulationInfoEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl2.BHOrderModule;
import com.kangxin.doctor.worktable.presenter.IBHWorktablePresenter;
import com.kangxin.doctor.worktable.view.IConsulationInfoView;
import io.reactivex.Observer;

public class BHWorktablePresenter
implements IBHWorktablePresenter {
    private IConsulationInfoView iConsulationInfoView;
    private IOrderModule orderModule;

    public BHWorktablePresenter(IConsulationInfoView iConsulationInfoView) {
        this.iConsulationInfoView = iConsulationInfoView;
        this.orderModule = new BHOrderModule();
    }

    @Override
    public void getConsulationInfo() {
        String accountId = VertifyDataUtil.getInstance((Context)this.iConsulationInfoView.injectContext()).getAccountId();
        if (!StringUtils.isEmpty((CharSequence)accountId)) {
            this.orderModule.getConsulationInfo(accountId).subscribe((Observer)new SampleObserver<ResponseBody<ConsulationInfoEntity>>(){

                public void onNext(ResponseBody<ConsulationInfoEntity> t) {
                    if (t.getCode() == 200 && t.getResult() != null) {
                        ConsulationInfoEntity result = (ConsulationInfoEntity)t.getResult();
                        BHWorktablePresenter.this.iConsulationInfoView.bindConsulationCountInfo(result.getToDealCount(), result.getFinishCount(), result.getNetinquiry(), result.getConsultation(), result.getServerPkg());
                    }
                }
            });
        }
    }
}

