/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl2;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BasePresenter;
import com.kangxin.common.byh.entity.PageEntity;
import com.kangxin.common.byh.entity.v2.ExpertItemEntityV2;
import com.kangxin.common.byh.module.IExpertModule;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.doctor.worktable.module.impl2.ExpertModule;
import com.kangxin.doctor.worktable.presenter.IExpertListPresenter;
import com.kangxin.doctor.worktable.view.IExpertListView;
import io.reactivex.Observer;
import java.util.ArrayList;
import java.util.List;

public class ExpertListPresenter
extends BasePresenter
implements IExpertListPresenter {
    private IExpertListView mExpertListView;
    private IExpertModule mExpertModule;

    public ExpertListPresenter(IExpertListView mExpertListView) {
        this.mExpertListView = mExpertListView;
        this.mExpertModule = new ExpertModule();
    }

    @Override
    public void getExpertList(final boolean isGetMore, String mSearchKey, int hospitalId, long departmentId, int businessType) {
        this.mExpertModule.getExpertByHospitalIdAndDepartmentV2(mSearchKey, "" + hospitalId, "" + departmentId, businessType, this.getPageIndex(isGetMore), this.getPageSize()).filter(listResponseBody -> {
            if (listResponseBody.getCode() == 200) {
                return true;
            }
            this.mExpertListView.error(listResponseBody.getMsg());
            return false;
        }).doOnNext(listResponseBody -> {
            if (listResponseBody.getResult() == null) {
                listResponseBody.setResult((Object)new PageEntity());
            }
        }).map(ResponseBody::getData).subscribe((Observer)new ProgressDialogObserver<PageEntity<ExpertItemEntityV2>>(){

            public void onNext(PageEntity<ExpertItemEntityV2> expertItemEntityV2PageEntity) {
                ExpertListPresenter.this.fullData(ExpertListPresenter.this.mExpertListView, expertItemEntityV2PageEntity.getContent(), isGetMore);
            }

            protected Context attachContext() {
                return ExpertListPresenter.this.mExpertListView.injectContext();
            }
        });
    }

    @Override
    public void getFilterExpertList(final boolean isGetMore, String mSearchKey, String cityCode, String departmentCode, int expertLevel, String orderType, int userTypeSpecialist, int businessType) {
        this.mExpertModule.getFilterExpertListBH(cityCode, mSearchKey, departmentCode, expertLevel, orderType, userTypeSpecialist, businessType, this.getPageIndex(isGetMore), this.getPageSize()).filter(listResponseBody -> {
            int code = listResponseBody.getCode();
            if (code == 200) {
                return true;
            }
            this.mExpertListView.error(listResponseBody.getMsg());
            return false;
        }).doOnNext(listResponseBody -> {
            if (listResponseBody.getResult() == null) {
                listResponseBody.setResult(new ArrayList());
            }
        }).map(ResponseBody::getResult).subscribe((Observer)new ProgressDialogObserver<List<ExpertItemEntityV2>>(){

            public void onNext(List<ExpertItemEntityV2> t) {
                ExpertListPresenter.this.fullData(ExpertListPresenter.this.mExpertListView, t, isGetMore);
            }

            protected Context attachContext() {
                return ExpertListPresenter.this.mExpertListView.injectContext();
            }
        });
    }
}

