/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl2;

import com.blankj.utilcode.util.LogUtils;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl2.BHOrderModule;
import com.kangxin.doctor.worktable.presenter.IPayPresenter;
import com.kangxin.doctor.worktable.view.IPayStatusListenerView;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class PayPresenter
implements IPayPresenter {
    private IOrderModule orderModule;
    IPayStatusListenerView view;
    Disposable disposable = null;

    public PayPresenter(IPayStatusListenerView view) {
        this.view = view;
        this.orderModule = new BHOrderModule();
    }

    @Override
    public void startPayStatusListener(String orderId) {
        this.disposable = this.orderModule.getOrderPayStatus(orderId).delay(2L, TimeUnit.SECONDS, true).repeat().observeOn(AndroidSchedulers.mainThread()).subscribe(t -> {
            if (t.getData() != null && t.getCode() == 200) {
                LogUtils.i((Object[])new Object[]{"\u76d1\u542c\u652f\u4ed8\u72b6\u6001 - \u542f\u52a8"});
                if ((Integer)t.getResult() > 10 && (Integer)t.getResult() != 50) {
                    LogUtils.i((Object[])new Object[]{"\u76d1\u542c\u652f\u4ed8\u72b6\u6001 - \u6210\u529f"});
                    this.view.paySuccess();
                    if (this.disposable != null) {
                        this.disposable.dispose();
                    }
                }
            }
        });
    }

    @Override
    public void closePayStatusListener() {
        if (this.disposable != null) {
            LogUtils.i((Object[])new Object[]{"\u76d1\u542c\u652f\u4ed8\u72b6\u6001 - \u53d6\u6d88"});
            if (this.disposable != null) {
                this.disposable.dispose();
            }
        }
    }
}

