/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.activity.FrameNotitleActivity;
import com.kangxin.doctor.worktable.module.clc.ClcOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import io.reactivex.Observer;
import java.io.Serializable;

public class ConsuNoticeReceiver
extends BroadcastReceiver {
    private static final String TAG = "ConsuNoticeReceiver";
    private Context mContext;

    public void onReceive(Context context, Intent intent) {
        Log.i((String)TAG, (String)"onReceive: *******************");
        if ("com.kangxin.doctor.worktable.action.notice".equals(intent.getAction())) {
            this.mContext = context;
            String orderId = intent.getStringExtra("ORDERID_KEY");
            String orderType = intent.getStringExtra("ORDER_TYPE_KEY");
            Log.i((String)TAG, (String)("onReceive: orderType:" + orderType));
            IUpdateVerStatus updateVerStatus = (IUpdateVerStatus)ARouter.getInstance().build("/service_update/SERVICE_UPDATE_VER_STATUS").navigation();
            if ("6".equals(orderType)) {
                updateVerStatus.changeConsuStatus(this.mContext, 4627);
                this.reqClcOrderForJumpPage(orderId);
            } else {
                updateVerStatus.changeConsuStatus(this.mContext, 4626);
                this.reqOrderStatusForJumpPage(orderId);
            }
        }
    }

    private void reqClcOrderForJumpPage(String orderId) {
        new ClcOrderModule().getOrderDetail(orderId).subscribe((Observer)new RxProgressObserver<ResponseBody<OrderDetailEntity>>(){

            public void onReqNext(ResponseBody<OrderDetailEntity> orderDetailEntityResponseBody) {
                OrderDetailEntity orderDetailEntity = (OrderDetailEntity)orderDetailEntityResponseBody.getResult();
                if (orderDetailEntity == null) {
                    return;
                }
                ConsuNoticeReceiver.this.jumpPageByStatus(orderDetailEntity);
            }

            public void onError(Throwable e) {
                super.onError(e);
                ToastUtils.showShort((CharSequence)e.toString());
            }
        });
    }

    private void reqOrderStatusForJumpPage(String orderId) {
        new OrderModule().getOrderDetail(orderId + "").subscribe((Observer)new RxProgressObserver<ResponseBody<OrderDetailEntity>>(){

            public void onReqNext(ResponseBody<OrderDetailEntity> orderDetailEntityResponseBody) {
                OrderDetailEntity orderDetailEntity = (OrderDetailEntity)orderDetailEntityResponseBody.getResult();
                if (orderDetailEntity == null) {
                    return;
                }
                ConsuNoticeReceiver.this.jumpPageByStatus(orderDetailEntity);
            }

            public void onError(Throwable e) {
                super.onError(e);
                ToastUtils.showShort((CharSequence)e.toString());
            }
        });
    }

    private void jumpPageByStatus(OrderDetailEntity orderDetailEntity) {
        Intent jumpIntent = new Intent(this.mContext, FrameNotitleActivity.class);
        jumpIntent.setFlags(0x10000000);
        jumpIntent.putExtra("MSG_JUMP_TYPE", 86400);
        jumpIntent.putExtra("ORDER_DETAILS_KEY", (Serializable)orderDetailEntity);
        this.mContext.startActivity(jumpIntent);
    }
}

