/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.util;

import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;

public class CountDownUtils {
    private final int MSG_WHAT_START = 10010;
    private WeakReference<TextView> mWeakReference;
    private long mCountDownMillis = 60000L;
    private String mHintText = "\u540e\u518d\u6b21\u53d1\u9001";
    private long mLastMillis;
    private long mIntervalMillis = 1000L;
    private int usableColorId = 17170450;
    private int unusableColorId = 0x1060000;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 10010: {
                    if (CountDownUtils.this.mLastMillis > 0L) {
                        CountDownUtils.this.setUsable(false);
                        CountDownUtils.this.mLastMillis = CountDownUtils.this.mLastMillis - CountDownUtils.this.mIntervalMillis;
                        if (CountDownUtils.this.mWeakReference.get() == null) break;
                        CountDownUtils.this.mHandler.sendEmptyMessageDelayed(10010, CountDownUtils.this.mIntervalMillis);
                        break;
                    }
                    CountDownUtils.this.setUsable(true);
                    if (CountDownUtils.this.onDownEndListener == null) break;
                    CountDownUtils.this.onDownEndListener.onEnd();
                }
            }
        }
    };
    private OnDownEndListener onDownEndListener;

    public void setOnDownEndListener(OnDownEndListener onDownEndListener) {
        this.onDownEndListener = onDownEndListener;
    }

    public CountDownUtils(TextView textView) {
        this.mWeakReference = new WeakReference<TextView>(textView);
    }

    public CountDownUtils(TextView textView, long countDownMillis) {
        this.mWeakReference = new WeakReference<TextView>(textView);
        this.mCountDownMillis = countDownMillis;
    }

    public CountDownUtils setCountDownMillis(long countDownMillis) {
        this.mCountDownMillis = countDownMillis;
        return this;
    }

    public void setUsable(boolean usable) {
        TextView mTextView = (TextView)this.mWeakReference.get();
        if (mTextView != null) {
            if (usable) {
                if (!mTextView.isClickable()) {
                    mTextView.setClickable(usable);
                    mTextView.setTextColor(mTextView.getResources().getColor(this.usableColorId));
                    mTextView.setText((CharSequence)this.mHintText);
                }
            } else {
                if (mTextView.isClickable()) {
                    mTextView.setClickable(usable);
                    mTextView.setTextColor(mTextView.getResources().getColor(this.unusableColorId));
                }
                String content = this.mLastMillis / 1000L + "s";
                mTextView.setText((CharSequence)content);
            }
        }
    }

    public CountDownUtils setCountDownColor(@ColorRes int usableColorId, @ColorRes int unusableColorId) {
        this.usableColorId = usableColorId;
        this.unusableColorId = unusableColorId;
        return this;
    }

    public CountDownUtils start() {
        this.mLastMillis = this.mCountDownMillis;
        this.mHandler.sendEmptyMessage(10010);
        return this;
    }

    public CountDownUtils setOnClickListener(final @Nullable View.OnClickListener onClickListener) {
        TextView mTextView = (TextView)this.mWeakReference.get();
        if (mTextView != null) {
            mTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CountDownUtils.this.mHandler.removeMessages(10010);
                    CountDownUtils.this.start();
                    onClickListener.onClick(v);
                }
            });
        }
        return this;
    }

    public CountDownUtils reset() {
        this.mLastMillis = 0L;
        this.mHandler.sendEmptyMessage(10010);
        return this;
    }

    public static interface OnDownEndListener {
        public void onEnd();
    }
}

