/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.os.AsyncTask;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;
import android.widget.ImageView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class ImageUtils {
    public static final String PATH = "/mypicture/con/";
    private static ImageView showImageView;
    private static String mUrl;

    public static String getFileName(String url) {
        int index = url.lastIndexOf("/") + 1;
        return url.substring(index);
    }

    public static void setImageBitmap(String url, ImageView iv) {
        showImageView = iv;
        mUrl = url;
        Bitmap loacalBitmap = ImageUtils.getLoacalBitmap(Environment.getExternalStorageDirectory() + PATH + ImageUtils.getFileName(url));
        if (loacalBitmap != null) {
            showImageView.setImageBitmap(loacalBitmap);
            Log.d((String)"ImageUtils", (String)"\u672c\u5730\u83b7\u53d6");
        } else {
            Log.d((String)"ImageUtils", (String)"\u7f51\u7edc\u83b7\u53d6");
            new DownImgAsyncTask().execute(new String[]{url});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmapByUrl(String url) {
        URL fileUrl = null;
        InputStream is = null;
        Bitmap bitmap = null;
        try {
            fileUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)fileUrl.openConnection();
            conn.setDoInput(true);
            conn.connect();
            is = conn.getInputStream();
            bitmap = BitmapFactory.decodeStream((InputStream)is);
            Log.d((String)"shaoace", (String)"1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            is = null;
        }
        return bitmap;
    }

    public static File saveImage(Bitmap bmp, String path, String fileName) {
        File appDir = new File(path);
        if (!appDir.exists()) {
            appDir.mkdir();
        }
        File file = new File(appDir, fileName);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getLoacalBitmap(String url) {
        if (url != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(url);
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fis);
                return bitmap;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                Bitmap bitmap = null;
                return bitmap;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    fis = null;
                }
            }
        }
        return null;
    }

    public static Bitmap getZoomImage(Bitmap orgBitmap, double newWidth, double newHeight) {
        if (null == orgBitmap) {
            return null;
        }
        if (orgBitmap.isRecycled()) {
            return null;
        }
        if (newWidth <= 0.0 || newHeight <= 0.0) {
            return null;
        }
        float width = orgBitmap.getWidth();
        float height = orgBitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)newWidth / width;
        float scaleHeight = (float)newHeight / height;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)orgBitmap, (int)0, (int)0, (int)((int)width), (int)((int)height), (Matrix)matrix, (boolean)true);
        return bitmap;
    }

    public static String getImageStr(String imgFile) {
        FileInputStream inputStream = null;
        byte[] data = null;
        try {
            inputStream = new FileInputStream(imgFile);
            data = new byte[((InputStream)inputStream).available()];
            ((InputStream)inputStream).read(data);
            ((InputStream)inputStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Base64.encodeToString(data, (int)0);
    }

    static class DownImgAsyncTask
    extends AsyncTask<String, Void, Bitmap> {
        DownImgAsyncTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Bitmap doInBackground(String ... params) {
            Bitmap b = ImageUtils.getBitmapByUrl(params[0]);
            return b;
        }

        protected void onPostExecute(Bitmap result) {
            super.onPostExecute((Object)result);
            if (result != null) {
                File file = ImageUtils.saveImage(result, Environment.getExternalStorageDirectory() + ImageUtils.PATH, ImageUtils.getFileName(mUrl));
                Log.d((String)"ImageUtils", (String)file.toString());
                showImageView.setImageBitmap(result);
            }
        }
    }
}

