/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    public static final String FORMAT_TIME = "HH:mm";
    public static final String FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATE_TIME_SECOND = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_MONTH_DAY_TIME = "MM-dd HH:mm";
    public static final String FORMAT_DATE = "yyyy-MM-dd";

    public static String getFormatToday(String dateFormat) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(currentTime);
    }

    public static Date stringToDate(String dateStr, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String dateToString(Date date, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(date);
    }

    public static String getChatTime(boolean hasYear, long timesamp) {
        String result;
        long clearTime = timesamp;
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        Date today = new Date(System.currentTimeMillis());
        Date otherDay = new Date(clearTime);
        int temp = Integer.parseInt(sdf.format(today)) - Integer.parseInt(sdf.format(otherDay));
        switch (temp) {
            case 0: {
                result = "\u4eca\u5929 " + TimeUtil.getHourAndMin(clearTime);
                break;
            }
            case 1: {
                result = "\u6628\u5929 " + TimeUtil.getHourAndMin(clearTime);
                break;
            }
            case 2: {
                result = "\u524d\u5929 " + TimeUtil.getHourAndMin(clearTime);
                break;
            }
            default: {
                result = TimeUtil.getTime(hasYear, clearTime);
            }
        }
        return result;
    }

    public static String getTime(boolean hasYear, long time) {
        String pattern = "yyyy-MM-dd HH:mm:ss";
        if (!hasYear) {
            pattern = FORMAT_MONTH_DAY_TIME;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(new Date(time));
    }

    private static String getHourAndMin(long time) {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_TIME);
        return format.format(new Date(time));
    }

    public static String getWeekOfDate(Date date) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static String utc2Local(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'X'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateUtcTime = sdf.format(date);
        Date utcDate = null;
        try {
            utcDate = sdf.parse(dateUtcTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        sdf.setTimeZone(TimeZone.getDefault());
        Date localDate = null;
        String localTime = sdf.format(utcDate.getTime());
        try {
            localDate = sdf.parse(localTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return sdf1.format(localDate);
    }

    public static String utc2Local2(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'X'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateUtcTime = sdf.format(date);
        Date utcDate = null;
        try {
            utcDate = sdf.parse(dateUtcTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        sdf.setTimeZone(TimeZone.getDefault());
        Date localDate = null;
        String localTime = sdf.format(utcDate.getTime());
        try {
            localDate = sdf.parse(localTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
        return sdf1.format(localDate);
    }

    public static String date2Timestamp(String date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return String.valueOf(sdf.parse(date).getTime());
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static String timeStamp2Date(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(time));
    }

    public static long stringToLong(String strTime, String formatType) {
        Date date = TimeUtil.stringToDate(strTime, formatType);
        if (date == null) {
            return 0L;
        }
        long currentTime = date.getTime();
        return currentTime;
    }

    public static String dateToStamp(String date) {
        SimpleDateFormat sf1 = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sf2 = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        String sfStr = "";
        try {
            sfStr = sf2.format(sf1.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sfStr;
    }
}

