/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import androidx.recyclerview.widget.RecyclerView;
import com.kangxin.doctor.worktable.util.Utils;
import com.kangxin.doctor.worktable.widget.ExcelPanel;
import com.kangxin.doctor.worktable.widget.IOnExcelPanelListener;
import com.kangxin.doctor.worktable.widget.LeftRecyclerViewAdapter;
import com.kangxin.doctor.worktable.widget.MajorRecyclerViewAdapter;
import com.kangxin.doctor.worktable.widget.RecyclerViewAdapter;
import com.kangxin.doctor.worktable.widget.TopRecyclerViewAdapter;
import java.util.List;

public abstract class BaseExcelPanelAdapter<T, L, M>
implements IOnExcelPanelListener {
    public static final int LOADING_VIEW_WIDTH = 0;
    private int leftCellWidth;
    private int topCellHeight;
    protected int amountAxisY = 0;
    private Context mContext;
    private RecyclerViewAdapter topRecyclerViewAdapter;
    private RecyclerViewAdapter leftRecyclerViewAdapter;
    private RecyclerViewAdapter mRecyclerViewAdapter;
    private View leftTopView;
    private ExcelPanel excelPanel;
    protected RecyclerView.OnScrollListener onScrollListener;
    protected List<T> topData;
    protected List<L> leftData;
    protected List<List<M>> majorData;

    public BaseExcelPanelAdapter(Context context) {
        this.mContext = context;
        this.initRecyclerViewAdapter();
    }

    private void initRecyclerViewAdapter() {
        this.topRecyclerViewAdapter = new TopRecyclerViewAdapter<T>(this.mContext, this.topData, this);
        this.leftRecyclerViewAdapter = new LeftRecyclerViewAdapter<L>(this.mContext, this.leftData, this);
        this.mRecyclerViewAdapter = new MajorRecyclerViewAdapter<List<M>>(this.mContext, this.majorData, this);
    }

    public void setTopData(List<T> topData) {
        this.topData = topData;
        this.topRecyclerViewAdapter.setData(topData);
    }

    public void setLeftData(List<L> leftData) {
        this.leftData = leftData;
        this.leftRecyclerViewAdapter.setData(leftData);
    }

    public void setMajorData(List<List<M>> majorData) {
        this.majorData = majorData;
        this.mRecyclerViewAdapter.setData(majorData);
    }

    public void setAllData(List<L> leftData, List<T> topData, List<List<M>> majorData) {
        this.setLeftData(leftData);
        this.setTopData(topData);
        this.setMajorData(majorData);
        this.excelPanel.scrollBy(0);
        this.excelPanel.fastScrollVerticalLeft();
        if (!(Utils.isEmpty(leftData) || Utils.isEmpty(topData) || this.excelPanel == null || Utils.isEmpty(majorData) || this.leftTopView != null)) {
            this.leftTopView = this.onCreateTopLeftView();
            this.excelPanel.addView(this.leftTopView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.leftCellWidth, this.topCellHeight));
        } else if (this.leftTopView != null) {
            if (Utils.isEmpty(leftData)) {
                this.leftTopView.setVisibility(8);
            } else {
                this.leftTopView.setVisibility(0);
            }
        }
    }

    public RecyclerViewAdapter getmRecyclerViewAdapter() {
        return this.mRecyclerViewAdapter;
    }

    public RecyclerViewAdapter getLeftRecyclerViewAdapter() {
        return this.leftRecyclerViewAdapter;
    }

    public RecyclerViewAdapter getTopRecyclerViewAdapter() {
        return this.topRecyclerViewAdapter;
    }

    public void setLeftCellWidth(int leftCellWidth) {
        this.leftCellWidth = leftCellWidth;
    }

    public void setTopCellHeight(int topCellHeight) {
        this.topCellHeight = topCellHeight;
    }

    public void setOnScrollListener(RecyclerView.OnScrollListener onScrollListener) {
        this.onScrollListener = onScrollListener;
        if (this.mRecyclerViewAdapter != null && this.mRecyclerViewAdapter instanceof MajorRecyclerViewAdapter) {
            ((MajorRecyclerViewAdapter)this.mRecyclerViewAdapter).setOnScrollListener(onScrollListener);
        }
    }

    public T getTopItem(int position) {
        if (Utils.isEmpty(this.topData) || position < 0 || position >= this.topData.size()) {
            return null;
        }
        return this.topData.get(position);
    }

    public L getLeftItem(int position) {
        if (Utils.isEmpty(this.leftData) || position < 0 || position >= this.leftData.size()) {
            return null;
        }
        return this.leftData.get(position);
    }

    public M getMajorItem(int x, int y) {
        if (Utils.isEmpty(this.majorData) || x < 0 || x >= this.majorData.size() || Utils.isEmpty(this.majorData.get(x)) || y < 0 || y >= this.majorData.get(x).size()) {
            return null;
        }
        return this.majorData.get(x).get(y);
    }

    public void setAmountAxisY(int amountAxisY) {
        this.amountAxisY = amountAxisY;
        if (this.mRecyclerViewAdapter != null && this.mRecyclerViewAdapter instanceof MajorRecyclerViewAdapter) {
            ((MajorRecyclerViewAdapter)this.mRecyclerViewAdapter).setAmountAxisY(amountAxisY);
        }
    }

    public void setExcelPanel(ExcelPanel excelPanel) {
        this.excelPanel = excelPanel;
    }

    protected View createTopStaticView() {
        View topStaticView = new View(this.mContext);
        int loadingWidth = Utils.dp2px(0, this.mContext);
        topStaticView.setLayoutParams(new ViewGroup.LayoutParams(loadingWidth, this.topCellHeight));
        return topStaticView;
    }

    protected View createMajorLoadingView() {
        int loadingWidth = Utils.dp2px(0, this.mContext);
        LinearLayout loadingView = new LinearLayout(this.mContext);
        loadingView.setOrientation(1);
        loadingView.setGravity(17);
        LinearLayout.LayoutParams lpp = new LinearLayout.LayoutParams(loadingWidth, -1);
        loadingView.setLayoutParams((ViewGroup.LayoutParams)lpp);
        ProgressBar progressBar = new ProgressBar(this.mContext);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(new ViewGroup.LayoutParams(Utils.dp2px(16, this.mContext), Utils.dp2px(16, this.mContext)));
        progressBar.setLayoutParams((ViewGroup.LayoutParams)lp);
        loadingView.addView((View)progressBar, (ViewGroup.LayoutParams)lp);
        return loadingView;
    }

    public void enableHeader() {
        if (this.topRecyclerViewAdapter != null && this.mRecyclerViewAdapter != null && this.excelPanel != null && (this.topRecyclerViewAdapter.getHeaderViewsCount() <= 0 || this.mRecyclerViewAdapter.getHeaderViewsCount() <= 0)) {
            this.topRecyclerViewAdapter.setHeaderView(this.createTopStaticView());
            this.mRecyclerViewAdapter.setHeaderView(this.createMajorLoadingView());
            this.excelPanel.setHasHeader(true);
            this.excelPanel.scrollBy(Utils.dp2px(0, this.mContext));
        }
    }

    public void enableFooter() {
        if (this.topRecyclerViewAdapter != null && this.mRecyclerViewAdapter != null && this.excelPanel != null && (this.topRecyclerViewAdapter.getFooterViewsCount() <= 0 || this.mRecyclerViewAdapter.getFooterViewsCount() <= 0)) {
            this.topRecyclerViewAdapter.setFooterView(this.createTopStaticView());
            this.mRecyclerViewAdapter.setFooterView(this.createMajorLoadingView());
            this.excelPanel.setHasFooter(true);
        }
    }

    public void disableHeader() {
        if (this.topRecyclerViewAdapter != null && this.mRecyclerViewAdapter != null && this.excelPanel != null && (this.topRecyclerViewAdapter.getHeaderViewsCount() > 0 || this.mRecyclerViewAdapter.getHeaderViewsCount() > 0)) {
            this.topRecyclerViewAdapter.setHeaderView(null);
            this.mRecyclerViewAdapter.setHeaderView(null);
            this.excelPanel.setHasHeader(false);
            this.excelPanel.scrollBy(-Utils.dp2px(0, this.mContext));
        }
    }

    public void disableFooter() {
        if (this.topRecyclerViewAdapter != null && this.mRecyclerViewAdapter != null && this.excelPanel != null && (this.topRecyclerViewAdapter.getFooterViewsCount() > 0 || this.mRecyclerViewAdapter.getFooterViewsCount() > 0)) {
            this.topRecyclerViewAdapter.setFooterView(null);
            this.mRecyclerViewAdapter.setFooterView(null);
            this.excelPanel.setHasFooter(false);
        }
    }

    @Override
    public int getCellItemViewType(int verticalPosition, int horizontalPosition) {
        return 2;
    }

    @Override
    public int getLeftItemViewType(int position) {
        return 2;
    }

    @Override
    public int getTopItemViewType(int position) {
        return 2;
    }

    public final void notifyDataSetChanged() {
        this.topRecyclerViewAdapter.notifyDataSetChanged();
        this.leftRecyclerViewAdapter.notifyDataSetChanged();
        ((MajorRecyclerViewAdapter)this.mRecyclerViewAdapter).customNotifyDataSetChanged();
    }

    @Override
    public void onAfterBind(RecyclerView.ViewHolder holder, int position) {
        if (this.excelPanel != null) {
            this.excelPanel.onAfterBind(holder, position);
        }
    }
}

