/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.ScheduleCalendarCellEntity;
import com.kangxin.doctor.worktable.entity.ScheduleCalendarColTitleEntity;
import com.kangxin.doctor.worktable.entity.ScheduleCalendarRowTitleEntity;
import com.kangxin.doctor.worktable.util.TimeUtil;
import com.kangxin.doctor.worktable.widget.BaseExcelPanelAdapter;

public class CustomAdapter
extends BaseExcelPanelAdapter<ScheduleCalendarRowTitleEntity, ScheduleCalendarColTitleEntity, ScheduleCalendarCellEntity> {
    private Context context;
    private View.OnClickListener blockListener;

    public CustomAdapter(Context context) {
        super(context);
        this.context = context;
    }

    public CustomAdapter(Context context, View.OnClickListener blockListener) {
        super(context);
        this.context = context;
        this.blockListener = blockListener;
    }

    @Override
    public RecyclerView.ViewHolder onCreateCellViewHolder(ViewGroup parent, int viewType) {
        View layout2 = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.by_schedule_status_normal_cell, parent, false);
        CellHolder cellHolder = new CellHolder(layout2);
        return cellHolder;
    }

    @Override
    public void onBindCellViewHolder(RecyclerView.ViewHolder holder, int verticalPosition, int horizontalPosition) {
        ScheduleCalendarCellEntity cell = (ScheduleCalendarCellEntity)this.getMajorItem(verticalPosition, horizontalPosition);
        if (null == holder || !(holder instanceof CellHolder) || cell == null) {
            return;
        }
        CellHolder viewHolder = (CellHolder)holder;
        viewHolder.cellContainer.setTag((Object)cell);
        viewHolder.cellContainer.setOnClickListener(this.blockListener);
        if (cell.getStatus() == 0) {
            viewHolder.bookingName.setText((CharSequence)"");
            viewHolder.channelName.setText((CharSequence)"");
            viewHolder.cellContainer.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
            viewHolder.view.setVisibility(8);
        } else if (horizontalPosition == 0) {
            if (cell.getStatus() == 0) {
                viewHolder.bookingName.setText((CharSequence)"");
                viewHolder.channelName.setText((CharSequence)"");
                viewHolder.cellContainer.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
                viewHolder.view.setVisibility(8);
            } else {
                viewHolder.bookingName.setText((CharSequence)cell.getBookingName());
                viewHolder.channelName.setText((CharSequence)cell.getChannelName());
                viewHolder.cellContainer.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.color_3979dd));
                viewHolder.bookingName.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
                viewHolder.channelName.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
                viewHolder.view.setVisibility(0);
            }
        } else if (cell.getStatus() == 0) {
            viewHolder.bookingName.setText((CharSequence)"");
            viewHolder.channelName.setText((CharSequence)"");
            viewHolder.cellContainer.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
            viewHolder.view.setVisibility(8);
        } else {
            viewHolder.bookingName.setText((CharSequence)cell.getBookingName());
            viewHolder.channelName.setText((CharSequence)cell.getChannelName());
            viewHolder.cellContainer.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.color_e0ebfc));
            viewHolder.bookingName.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.color_3576E0));
            viewHolder.channelName.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.color_3576E0));
            viewHolder.view.setVisibility(0);
        }
    }

    @Override
    public RecyclerView.ViewHolder onCreateTopViewHolder(ViewGroup parent, int viewType) {
        View layout2 = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.by_schedule_status_top_header_item, parent, false);
        TopHolder topHolder = new TopHolder(layout2);
        return topHolder;
    }

    @Override
    public void onBindTopViewHolder(RecyclerView.ViewHolder holder, int position) {
        ScheduleCalendarRowTitleEntity rowTitle = (ScheduleCalendarRowTitleEntity)this.getTopItem(position);
        if (null == holder || !(holder instanceof TopHolder) || rowTitle == null) {
            return;
        }
        TopHolder viewHolder = (TopHolder)holder;
        if (position == 0) {
            viewHolder.roomWeek.setText((CharSequence)CustomAdapter.roomWeek(rowTitle.getWeekString()));
            viewHolder.roomWeek.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.color_3576E0));
            viewHolder.roomDate.setText((CharSequence)TimeUtil.getChatTime(false, Long.valueOf(TimeUtil.date2Timestamp(rowTitle.getDateString().substring(5), "MM-dd"))));
            viewHolder.roomDate.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.color_3576E0));
        } else {
            viewHolder.roomWeek.setText((CharSequence)CustomAdapter.roomWeek(rowTitle.getWeekString()));
            viewHolder.roomWeek.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.color_666666));
            viewHolder.roomDate.setText((CharSequence)rowTitle.getDateString().substring(5));
            viewHolder.roomDate.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.color_666666));
        }
        viewHolder.availableRoomCount.setText((CharSequence)("\u5269\u4f59" + rowTitle.getAvailableRoomCount() + "\u95f4"));
    }

    public static String roomWeek(String weekStr) {
        if (weekStr.equals("1")) {
            return "\u4e00";
        }
        if (weekStr.equals("2")) {
            return "\u4e8c";
        }
        if (weekStr.equals("3")) {
            return "\u4e09";
        }
        if (weekStr.equals("4")) {
            return "\u56db";
        }
        if (weekStr.equals("5")) {
            return "\u4e94";
        }
        if (weekStr.equals("6")) {
            return "\u516d";
        }
        if (weekStr.equals("7")) {
            return "\u65e5";
        }
        return null;
    }

    @Override
    public RecyclerView.ViewHolder onCreateLeftViewHolder(ViewGroup parent, int viewType) {
        View layout2 = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.by_schedule_status_left_header_item, parent, false);
        LeftHolder leftHolder = new LeftHolder(layout2);
        return leftHolder;
    }

    @Override
    public void onBindLeftViewHolder(RecyclerView.ViewHolder holder, int position) {
        ScheduleCalendarColTitleEntity colTitle = (ScheduleCalendarColTitleEntity)this.getLeftItem(position);
        if (null == holder || !(holder instanceof LeftHolder) || colTitle == null) {
            return;
        }
        LeftHolder viewHolder = (LeftHolder)holder;
        viewHolder.roomNumberLabel.setText((CharSequence)colTitle.getRoomNumber());
        viewHolder.roomTypeLabel.setText((CharSequence)colTitle.getRoomTypeName());
        ViewGroup.LayoutParams lp = viewHolder.root.getLayoutParams();
        viewHolder.root.setLayoutParams(lp);
    }

    @Override
    public View onCreateTopLeftView() {
        return LayoutInflater.from((Context)this.context).inflate(R.layout.by_schedule_status_normal, null);
    }

    static class LeftHolder
    extends RecyclerView.ViewHolder {
        public final TextView roomNumberLabel;
        public final TextView roomTypeLabel;
        public final View root;

        public LeftHolder(View itemView) {
            super(itemView);
            this.root = itemView.findViewById(R.id.root);
            this.roomNumberLabel = (TextView)itemView.findViewById(R.id.room_number_label);
            this.roomTypeLabel = (TextView)itemView.findViewById(R.id.room_type_label);
        }
    }

    static class TopHolder
    extends RecyclerView.ViewHolder {
        public final TextView roomDate;
        public final TextView roomWeek;
        public final TextView availableRoomCount;

        public TopHolder(View itemView) {
            super(itemView);
            this.roomDate = (TextView)itemView.findViewById(R.id.data_label);
            this.roomWeek = (TextView)itemView.findViewById(R.id.week_label);
            this.availableRoomCount = (TextView)itemView.findViewById(R.id.available_room_count);
        }
    }

    static class CellHolder
    extends RecyclerView.ViewHolder {
        public final TextView bookingName;
        public final TextView channelName;
        public final LinearLayout cellContainer;
        public final View view;

        public CellHolder(View itemView) {
            super(itemView);
            this.bookingName = (TextView)itemView.findViewById(R.id.booking_name);
            this.channelName = (TextView)itemView.findViewById(R.id.channel_name);
            this.cellContainer = (LinearLayout)itemView.findViewById(R.id.pms_cell_container);
            this.view = itemView.findViewById(R.id.right_line);
        }
    }
}

