/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.kangxin.doctor.worktable.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class DatePickerView
extends View {
    private Context context;
    private boolean loop = true;
    public static final float MARGIN_ALPHA = 2.8f;
    public static final float SPEED = 10.0f;
    private List<String> mDataList;
    private int mCurrentSelected;
    private Paint mPaint;
    private Paint nPaint;
    private float mMaxTextSize = 80.0f;
    private float mMinTextSize = 40.0f;
    private float mMaxTextAlpha = 255.0f;
    private float mMinTextAlpha = 120.0f;
    private int mViewHeight;
    private int mViewWidth;
    private float mLastDownY;
    private float mMoveLen = 0.0f;
    private boolean isInit = false;
    private boolean canScroll = true;
    private onSelectListener mSelectListener;
    private Timer timer;
    private MyTimerTask mTask;
    private Handler updateHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (Math.abs(DatePickerView.this.mMoveLen) < 10.0f) {
                DatePickerView.this.mMoveLen = 0.0f;
                if (DatePickerView.this.mTask != null) {
                    DatePickerView.this.mTask.cancel();
                    DatePickerView.this.mTask = null;
                    DatePickerView.this.performSelect();
                }
            } else {
                DatePickerView.this.mMoveLen = DatePickerView.this.mMoveLen - DatePickerView.this.mMoveLen / Math.abs(DatePickerView.this.mMoveLen) * 10.0f;
            }
            DatePickerView.this.invalidate();
        }
    };

    public DatePickerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init();
    }

    public void setOnSelectListener(onSelectListener listener) {
        this.mSelectListener = listener;
    }

    private void performSelect() {
        if (this.mSelectListener != null) {
            this.mSelectListener.onSelect(this.mDataList.get(this.mCurrentSelected));
        }
    }

    public void setData(List<String> datas) {
        this.mDataList = datas;
        this.mCurrentSelected = datas.size() / 4;
        this.invalidate();
    }

    public void setSelected(int selected) {
        this.mCurrentSelected = selected;
        if (this.loop) {
            int distance = this.mDataList.size() / 2 - this.mCurrentSelected;
            if (distance < 0) {
                for (int i = 0; i < -distance; ++i) {
                    this.moveHeadToTail();
                    --this.mCurrentSelected;
                }
            } else if (distance > 0) {
                for (int i = 0; i < distance; ++i) {
                    this.moveTailToHead();
                    ++this.mCurrentSelected;
                }
            }
        }
        this.invalidate();
    }

    public void setSelected(String mSelectItem) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            if (!this.mDataList.get(i).equals(mSelectItem)) continue;
            this.setSelected(i);
            break;
        }
    }

    private void moveHeadToTail() {
        if (this.loop) {
            String head = this.mDataList.get(0);
            this.mDataList.remove(0);
            this.mDataList.add(head);
        }
    }

    private void moveTailToHead() {
        if (this.loop) {
            String tail = this.mDataList.get(this.mDataList.size() - 1);
            this.mDataList.remove(this.mDataList.size() - 1);
            this.mDataList.add(0, tail);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mViewHeight = this.getMeasuredHeight();
        this.mViewWidth = this.getMeasuredWidth();
        this.mMaxTextSize = (float)this.mViewHeight / 7.0f;
        this.mMinTextSize = this.mMaxTextSize / 2.2f;
        this.isInit = true;
        this.invalidate();
    }

    private void init() {
        this.timer = new Timer();
        this.mDataList = new ArrayList<String>();
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setColor(ContextCompat.getColor((Context)this.context, (int)R.color.black));
        this.nPaint = new Paint(1);
        this.nPaint.setStyle(Paint.Style.FILL);
        this.nPaint.setTextAlign(Paint.Align.CENTER);
        this.nPaint.setColor(ContextCompat.getColor((Context)this.context, (int)R.color.black));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInit) {
            this.drawData(canvas);
        }
    }

    private void drawData(Canvas canvas) {
        float scale = this.parabola((float)this.mViewHeight / 4.0f, this.mMoveLen);
        float size = (this.mMaxTextSize - this.mMinTextSize) * scale + this.mMinTextSize;
        this.mPaint.setTextSize(size);
        this.mPaint.setAlpha((int)((this.mMaxTextAlpha - this.mMinTextAlpha) * scale + this.mMinTextAlpha));
        float x = (float)((double)this.mViewWidth / 2.0);
        float y = (float)((double)this.mViewHeight / 2.0 + (double)this.mMoveLen);
        Paint.FontMetricsInt fmi = this.mPaint.getFontMetricsInt();
        float baseline = (float)((double)y - ((double)fmi.bottom / 2.0 + (double)fmi.top / 2.0));
        canvas.drawText(this.mDataList.get(this.mCurrentSelected), x, baseline, this.mPaint);
        int i = 1;
        while (this.mCurrentSelected - i >= 0) {
            this.drawOtherText(canvas, i, -1);
            ++i;
        }
        i = 1;
        while (this.mCurrentSelected + i < this.mDataList.size()) {
            this.drawOtherText(canvas, i, 1);
            ++i;
        }
    }

    private void drawOtherText(Canvas canvas, int position, int type) {
        float d = 2.8f * this.mMinTextSize * (float)position + (float)type * this.mMoveLen;
        float scale = this.parabola((float)this.mViewHeight / 4.0f, d);
        float size = (this.mMaxTextSize - this.mMinTextSize) * scale + this.mMinTextSize;
        this.nPaint.setTextSize(size);
        this.nPaint.setAlpha((int)((this.mMaxTextAlpha - this.mMinTextAlpha) * scale + this.mMinTextAlpha));
        float y = (float)((double)this.mViewHeight / 2.0 + (double)((float)type * d));
        Paint.FontMetricsInt fmi = this.nPaint.getFontMetricsInt();
        float baseline = (float)((double)y - ((double)fmi.bottom / 2.0 + (double)fmi.top / 2.0));
        canvas.drawText(this.mDataList.get(this.mCurrentSelected + type * position), (float)((double)this.mViewWidth / 2.0), baseline, this.nPaint);
    }

    private float parabola(float zero, float x) {
        float f = (float)(1.0 - Math.pow(x / zero, 2.0));
        return f < 0.0f ? 0.0f : f;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.doDown(event);
                break;
            }
            case 2: {
                this.mMoveLen += event.getY() - this.mLastDownY;
                if (this.mMoveLen > 2.8f * this.mMinTextSize / 2.0f) {
                    if (!this.loop && this.mCurrentSelected == 0) {
                        this.mLastDownY = event.getY();
                        this.invalidate();
                        return true;
                    }
                    if (!this.loop) {
                        --this.mCurrentSelected;
                    }
                    this.moveTailToHead();
                    this.mMoveLen -= 2.8f * this.mMinTextSize;
                } else if (this.mMoveLen < -2.8f * this.mMinTextSize / 2.0f) {
                    if (this.mCurrentSelected == this.mDataList.size() - 1) {
                        this.mLastDownY = event.getY();
                        this.invalidate();
                        return true;
                    }
                    if (!this.loop) {
                        ++this.mCurrentSelected;
                    }
                    this.moveHeadToTail();
                    this.mMoveLen += 2.8f * this.mMinTextSize;
                }
                this.mLastDownY = event.getY();
                this.invalidate();
                break;
            }
            case 1: {
                this.doUp();
            }
        }
        return true;
    }

    private void doDown(MotionEvent event) {
        if (this.mTask != null) {
            this.mTask.cancel();
            this.mTask = null;
        }
        this.mLastDownY = event.getY();
    }

    private void doUp() {
        if ((double)Math.abs(this.mMoveLen) < 1.0E-4) {
            this.mMoveLen = 0.0f;
            return;
        }
        if (this.mTask != null) {
            this.mTask.cancel();
            this.mTask = null;
        }
        this.mTask = new MyTimerTask(this.updateHandler);
        this.timer.schedule((TimerTask)this.mTask, 0L, 10L);
    }

    public void setCanScroll(boolean canScroll) {
        this.canScroll = canScroll;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        return this.canScroll && super.dispatchTouchEvent(event);
    }

    public void setIsLoop(boolean isLoop) {
        this.loop = isLoop;
    }

    public static interface onSelectListener {
        public void onSelect(String var1);
    }

    class MyTimerTask
    extends TimerTask {
        Handler handler;

        public MyTimerTask(Handler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            this.handler.sendMessage(this.handler.obtainMessage());
        }
    }
}

