/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.util.Utils;
import com.kangxin.doctor.worktable.widget.BaseExcelPanelAdapter;
import com.kangxin.doctor.worktable.widget.ExcelMajorRecyclerView;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ExcelPanel
extends FrameLayout
implements ViewTreeObserver.OnGlobalLayoutListener {
    public static final int TAG_KEY = R.id.lib_excel_panel_tag_key;
    public static final int DEFAULT_LENGTH = 48;
    public static final int DEFAULT_LENGTHS = 41;
    public static final int LOADING_VIEW_WIDTH = 0;
    private int leftCellWidth;
    private int topCellHeight;
    private int normalCellWidth;
    private int loadingViewWidth;
    private int amountAxisX = 0;
    private int amountAxisY = 0;
    private int dividerHeight;
    private boolean hasHeader;
    private boolean hasFooter;
    private boolean dividerLineVisible;
    protected View dividerLine;
    protected RecyclerView mRecyclerView;
    protected RecyclerView topRecyclerView;
    protected RecyclerView leftRecyclerView;
    protected BaseExcelPanelAdapter excelPanelAdapter;
    private static Map<Integer, Integer> indexHeight;
    private OnLoadMoreListener onLoadMoreListener;
    private RecyclerView.OnScrollListener contentScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            int firstVisibleItem;
            super.onScrolled(recyclerView, dx, dy);
            ExcelPanel.this.amountAxisX = ExcelPanel.this.amountAxisX + dx;
            ExcelPanel.this.fastScrollTo(ExcelPanel.this.amountAxisX, ExcelPanel.this.mRecyclerView, ExcelPanel.this.loadingViewWidth, ExcelPanel.this.hasHeader);
            ExcelPanel.this.fastScrollTo(ExcelPanel.this.amountAxisX, ExcelPanel.this.topRecyclerView, ExcelPanel.this.loadingViewWidth, ExcelPanel.this.hasHeader);
            if (dx == 0 && dy == 0) {
                return;
            }
            LinearLayoutManager manager = (LinearLayoutManager)recyclerView.getLayoutManager();
            int visibleItemCount = recyclerView.getChildCount();
            int totalItemCount = manager.getItemCount();
            if (totalItemCount - visibleItemCount > (firstVisibleItem = manager.findFirstVisibleItemPosition()) || ExcelPanel.this.onLoadMoreListener == null || ExcelPanel.this.hasFooter) {
                // empty if block
            }
            if (ExcelPanel.this.amountAxisX >= ExcelPanel.this.loadingViewWidth || ExcelPanel.this.onLoadMoreListener == null || ExcelPanel.this.hasHeader) {
                // empty if block
            }
            if ((ExcelPanel.this.hasHeader && ExcelPanel.this.amountAxisX > ExcelPanel.this.loadingViewWidth || !ExcelPanel.this.hasHeader && ExcelPanel.this.amountAxisX > 0) && ExcelPanel.this.dividerLineVisible) {
                ExcelPanel.this.dividerLine.setVisibility(0);
            } else {
                ExcelPanel.this.dividerLine.setVisibility(8);
            }
        }
    };
    private RecyclerView.OnScrollListener leftScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            ExcelPanel.this.amountAxisY = ExcelPanel.this.amountAxisY + dy;
            for (int i = 0; i < ExcelPanel.this.mRecyclerView.getChildCount(); ++i) {
                if (!(ExcelPanel.this.mRecyclerView.getChildAt(i) instanceof RecyclerView)) continue;
                RecyclerView recyclerView1 = (RecyclerView)ExcelPanel.this.mRecyclerView.getChildAt(i);
                ExcelPanel.fastScrollVertical(ExcelPanel.this.amountAxisY, recyclerView1);
            }
            ExcelPanel.fastScrollVertical(ExcelPanel.this.amountAxisY, ExcelPanel.this.leftRecyclerView);
            if (ExcelPanel.this.excelPanelAdapter != null) {
                ExcelPanel.this.excelPanelAdapter.setAmountAxisY(ExcelPanel.this.amountAxisY);
            }
        }
    };

    public ExcelPanel(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcelPanel(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.ExcelPanel, 0, 0);
        try {
            this.leftCellWidth = (int)a.getDimension(R.styleable.ExcelPanel_left_cell_width, (float)Utils.dp2px(41, this.getContext()));
            this.topCellHeight = (int)a.getDimension(R.styleable.ExcelPanel_top_cell_height, (float)Utils.dp2px(48, this.getContext()));
            this.normalCellWidth = (int)a.getDimension(R.styleable.ExcelPanel_normal_cell_width, (float)Utils.dp2px(41, this.getContext()));
        }
        finally {
            a.recycle();
        }
        indexHeight = new TreeMap<Integer, Integer>();
        this.loadingViewWidth = Utils.dp2px(0, this.getContext());
        this.initWidget();
    }

    private void initWidget() {
        this.mRecyclerView = this.createMajorContent();
        this.addView((View)this.mRecyclerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        FrameLayout.LayoutParams mlp = (FrameLayout.LayoutParams)this.mRecyclerView.getLayoutParams();
        mlp.leftMargin = this.leftCellWidth;
        mlp.topMargin = this.topCellHeight;
        this.mRecyclerView.setLayoutParams((ViewGroup.LayoutParams)mlp);
        this.topRecyclerView = this.createTopHeader();
        this.addView((View)this.topRecyclerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, this.topCellHeight));
        FrameLayout.LayoutParams tlp = (FrameLayout.LayoutParams)this.topRecyclerView.getLayoutParams();
        tlp.leftMargin = this.leftCellWidth;
        this.topRecyclerView.setLayoutParams((ViewGroup.LayoutParams)tlp);
        this.leftRecyclerView = this.createLeftHeader();
        this.addView((View)this.leftRecyclerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.leftCellWidth, -2));
        FrameLayout.LayoutParams llp = (FrameLayout.LayoutParams)this.leftRecyclerView.getLayoutParams();
        llp.topMargin = this.topCellHeight;
        this.leftRecyclerView.setLayoutParams((ViewGroup.LayoutParams)llp);
        this.dividerLine = this.createDividerToLeftHeader();
        this.addView(this.dividerLine, new ViewGroup.LayoutParams(1, -2));
        FrameLayout.LayoutParams lineLp = (FrameLayout.LayoutParams)this.dividerLine.getLayoutParams();
        lineLp.leftMargin = this.leftCellWidth;
        this.dividerLine.setLayoutParams((ViewGroup.LayoutParams)lineLp);
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    public void onGlobalLayout() {
        if (this.dividerHeight == this.getMeasuredHeight() && this.getMeasuredHeight() != 0) {
            this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        FrameLayout.LayoutParams lineLp1 = (FrameLayout.LayoutParams)this.dividerLine.getLayoutParams();
        this.dividerHeight = lineLp1.height = this.getMeasuredHeight();
        this.dividerLine.setLayoutParams((ViewGroup.LayoutParams)lineLp1);
    }

    protected RecyclerView createTopHeader() {
        RecyclerView recyclerView = new RecyclerView(this.getContext());
        recyclerView.setLayoutManager(this.getTopLayoutManager());
        recyclerView.addOnScrollListener(this.contentScrollListener);
        return recyclerView;
    }

    protected RecyclerView createLeftHeader() {
        RecyclerView recyclerView = new RecyclerView(this.getContext());
        recyclerView.setLayoutManager(this.getLeftLayoutManager());
        recyclerView.addOnScrollListener(this.leftScrollListener);
        return recyclerView;
    }

    protected RecyclerView createMajorContent() {
        ExcelMajorRecyclerView recyclerView = new ExcelMajorRecyclerView(this.getContext());
        recyclerView.setLayoutManager(this.getLayoutManager());
        recyclerView.addOnScrollListener(this.contentScrollListener);
        return recyclerView;
    }

    protected View createDividerToLeftHeader() {
        View view = new View(this.getContext());
        view.setVisibility(8);
        view.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.bg_line));
        return view;
    }

    protected RecyclerView.LayoutManager getLayoutManager() {
        if (null == this.mRecyclerView || null == this.mRecyclerView.getLayoutManager()) {
            LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
            layoutManager.setOrientation(0);
            return layoutManager;
        }
        return this.mRecyclerView.getLayoutManager();
    }

    private RecyclerView.LayoutManager getTopLayoutManager() {
        if (null == this.topRecyclerView || null == this.topRecyclerView.getLayoutManager()) {
            LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
            layoutManager.setOrientation(0);
            return layoutManager;
        }
        return this.topRecyclerView.getLayoutManager();
    }

    private RecyclerView.LayoutManager getLeftLayoutManager() {
        if (null == this.leftRecyclerView || null == this.leftRecyclerView.getLayoutManager()) {
            LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
            layoutManager.setOrientation(1);
            return layoutManager;
        }
        return this.leftRecyclerView.getLayoutManager();
    }

    void fastScrollVerticalLeft() {
        ExcelPanel.fastScrollVertical(this.amountAxisY, this.leftRecyclerView);
    }

    static void fastScrollVertical(int amountAxis, RecyclerView recyclerView) {
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
        if (indexHeight == null) {
            indexHeight = new TreeMap<Integer, Integer>();
            linearLayoutManager.scrollToPositionWithOffset(0, -amountAxis);
        } else {
            int height;
            int total = 0;
            int count = 0;
            Iterator<Integer> iterator = indexHeight.keySet().iterator();
            while (null != iterator && iterator.hasNext() && total + (height = indexHeight.get(iterator.next()).intValue()) < amountAxis) {
                total += height;
                ++count;
            }
            linearLayoutManager.scrollToPositionWithOffset(count, -(amountAxis - total));
        }
    }

    private void fastScrollTo(int amountAxis, RecyclerView recyclerView, int offset, boolean hasHeader) {
        int position = 0;
        int width = this.normalCellWidth;
        if (amountAxis >= offset && hasHeader) {
            amountAxis -= offset;
            ++position;
        }
        position += amountAxis / width;
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
        linearLayoutManager.scrollToPositionWithOffset(position, -(amountAxis %= width));
    }

    public void setAdapter(BaseExcelPanelAdapter excelPanelAdapter) {
        if (excelPanelAdapter != null) {
            this.excelPanelAdapter = excelPanelAdapter;
            this.excelPanelAdapter.setLeftCellWidth(this.leftCellWidth);
            this.excelPanelAdapter.setTopCellHeight(this.topCellHeight);
            this.excelPanelAdapter.setOnScrollListener(this.leftScrollListener);
            this.excelPanelAdapter.setExcelPanel(this);
            this.distributeAdapter();
        }
    }

    private void distributeAdapter() {
        if (this.leftRecyclerView != null) {
            this.leftRecyclerView.setAdapter((RecyclerView.Adapter)this.excelPanelAdapter.getLeftRecyclerViewAdapter());
        }
        if (this.topRecyclerView != null) {
            this.topRecyclerView.setAdapter((RecyclerView.Adapter)this.excelPanelAdapter.getTopRecyclerViewAdapter());
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.excelPanelAdapter.getmRecyclerViewAdapter());
        }
    }

    void scrollBy(int dx) {
        this.contentScrollListener.onScrolled(this.mRecyclerView, dx, 0);
    }

    public void setOnLoadMoreListener(OnLoadMoreListener onLoadMoreListener) {
        this.onLoadMoreListener = onLoadMoreListener;
    }

    void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    void setHasFooter(boolean hasFooter) {
        this.hasFooter = hasFooter;
    }

    public boolean canChildScrollUp() {
        return this.amountAxisY > 0;
    }

    public void reset() {
        if (this.excelPanelAdapter != null) {
            this.excelPanelAdapter.disableFooter();
            this.excelPanelAdapter.disableHeader();
        }
        if (indexHeight == null) {
            indexHeight = new TreeMap<Integer, Integer>();
        }
        indexHeight.clear();
        this.amountAxisY = 0;
        this.amountAxisX = 0;
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    public void addHistorySize(int size) {
        if (size > 0) {
            this.contentScrollListener.onScrolled(this.topRecyclerView, this.normalCellWidth * size, 0);
        }
    }

    public int findFirstVisibleItemPosition() {
        int position = -1;
        if (this.mRecyclerView.getLayoutManager() != null && this.excelPanelAdapter != null) {
            LinearLayoutManager mLinearLayoutManager = (LinearLayoutManager)this.mRecyclerView.getLayoutManager();
            int firstVisibleItem = mLinearLayoutManager.findFirstVisibleItemPosition();
            if (this.hasHeader) {
                return firstVisibleItem - 1;
            }
            return firstVisibleItem;
        }
        return position;
    }

    public void enableDividerLine(boolean visible) {
        this.dividerLineVisible = visible;
    }

    public void onAfterBind(RecyclerView.ViewHolder holder, int position) {
        if (holder != null && holder.itemView != null) {
            if (indexHeight == null) {
                indexHeight = new TreeMap<Integer, Integer>();
            }
            ViewGroup.LayoutParams layoutParams = holder.itemView.getLayoutParams();
            indexHeight.put(position, layoutParams.height);
        }
    }

    public static interface OnLoadMoreListener {
        public void onLoadMore();

        public void onLoadHistory();
    }
}

