/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupWindow;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.SizeUtils;
import com.kangxin.common.byh.entity.v2.HospitalDepEntityV2;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.past.AppManager;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.v2.BHDepSelectAdapter;
import com.kangxin.doctor.worktable.presenter.IMenuDepartmentPresenter;
import com.kangxin.doctor.worktable.presenter.impl.MenuDepartmentPresenter;
import com.kangxin.doctor.worktable.view.IMenuDepartmentView;
import java.util.ArrayList;
import java.util.List;

public class ExpertDepSelectPopWindow
extends PopupWindow
implements IMenuDepartmentView {
    protected ImageView vClose;
    protected RecyclerView vRecyclerView;
    protected BHDepSelectAdapter mAdapter;
    protected ArrayList<HospitalDepEntityV2> deps = new ArrayList();
    protected OnExpertDepSelectClickListener onExpertDepSelectClickListener;
    protected IMenuDepartmentPresenter mMenuDepartmentPresenter = new MenuDepartmentPresenter(this);
    protected Long hospitalId = -1L;

    public ExpertDepSelectPopWindow(View contentView, String hospitalId) {
        super(contentView, -1, SizeUtils.dp2px((float)500.0f));
        this.setBackgroundDrawable((Drawable)new ColorDrawable(-1895825408));
        this.setTouchable(true);
        this.setOutsideTouchable(true);
        this.setFocusable(false);
        if (!TextUtils.isEmpty((CharSequence)hospitalId)) {
            this.hospitalId = Long.parseLong(hospitalId);
        }
        this.init();
    }

    protected void init() {
        this.vClose = (ImageView)this.getContentView().findViewById(R.id.vClose);
        this.vRecyclerView = (RecyclerView)this.getContentView().findViewById(R.id.vRecyclerView);
        this.vClose.setOnClickListener(v -> this.dismiss());
        this.mAdapter = new BHDepSelectAdapter(this.deps);
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContentView().getContext()));
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        Context context = AppManager.getAppManager().currentActivity().getApplicationContext();
        int doctorId = VertifyDataUtil.getInstance((Context)context).getLoginUserId();
        String openCode = VertifyDataUtil.getInstance((Context)this.getContentView().getContext()).getOpenCode();
        this.mMenuDepartmentPresenter.getMenuDepartmentDatas(this.hospitalId, Long.valueOf(doctorId), openCode);
        this.dispatchEvent();
    }

    protected void dispatchEvent() {
        this.mAdapter.setOnDepartmentItemClickListener((hospitalId, departmentId) -> {
            if (this.onExpertDepSelectClickListener != null) {
                this.onExpertDepSelectClickListener.select(hospitalId, departmentId);
            }
            this.dismiss();
        });
    }

    public void showAsDropDownAndFull(View anchor, int xoff, int yoff) {
        int maxAvailableHeight = this.getMaxAvailableHeight(anchor, yoff);
        this.setHeight(maxAvailableHeight);
        this.showAsDropDown(anchor, xoff, yoff);
    }

    @Override
    public void bindData(List result) {
        if (this.mAdapter.getData().size() > 0) {
            return;
        }
        this.mAdapter.setNewData(result);
        this.mAdapter.notifyDataSetChanged();
    }

    public void setOnExpertDepSelectClickListener(OnExpertDepSelectClickListener onExpertDepSelectClickListener) {
        this.onExpertDepSelectClickListener = onExpertDepSelectClickListener;
    }

    public static interface OnExpertDepSelectClickListener {
        public void select(int var1, long var2);
    }
}

