/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.widget.TextView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.DepartmentEntity;
import com.kangxin.common.byh.entity.MenuDepartmentList;
import com.kangxin.common.byh.module.IHospitalModule;
import com.kangxin.common.byh.module.impl.HospitalModule;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.ProgressDialogObserver;
import com.kangxin.common.widget.adapter.RelationMoveAdapter;
import com.kangxin.doctor.worktable.R;
import io.reactivex.Observer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HospitalDepAdapter
extends RelationMoveAdapter<MenuDepartmentList> {
    private Context mContext;
    private IHospitalModule hospitalModule;
    private List<MenuDepartmentList> hopitalList;
    private List<DepartmentEntity> departmentEntities;
    private boolean isStandardDepartment = false;

    public HospitalDepAdapter(final Context mContext, long mHospitalId) {
        this.mContext = mContext;
        this.hospitalModule = new HospitalModule();
        Long doctodId = VertifyDataUtil.getInstance((Context)mContext).getLoginUserId();
        this.hospitalModule.getHospitalAllDepartmentList(Long.valueOf(mHospitalId), doctodId).subscribe((Observer)new ProgressDialogObserver<ResponseBody<List<MenuDepartmentList>>>(){

            public void onNext(ResponseBody<List<MenuDepartmentList>> listResponseBody) {
                HospitalDepAdapter.this.hopitalList = (List)listResponseBody.getResult();
                if (HospitalDepAdapter.this.hopitalList != null) {
                    HospitalDepAdapter.this.departmentEntities = ((MenuDepartmentList)HospitalDepAdapter.this.hopitalList.get(0)).getHospitalDepartmentList();
                }
                HospitalDepAdapter.this.flushView();
            }

            protected Context attachContext() {
                return mContext;
            }
        });
    }

    public HospitalDepAdapter(final Context mContext, final boolean isShowHotDepartment) {
        this.mContext = mContext;
        this.hospitalModule = new HospitalModule();
        this.isStandardDepartment = true;
        this.hospitalModule.getStandardDepartment().subscribe((Observer)new ProgressDialogObserver<ResponseBody<List<MenuDepartmentList>>>(){

            public void onNext(ResponseBody<List<MenuDepartmentList>> listResponseBody) {
                if (isShowHotDepartment) {
                    HospitalDepAdapter.this.hopitalList = HospitalDepAdapter.this.parseHotDepartment((List)listResponseBody.getResult());
                } else {
                    HospitalDepAdapter.this.hopitalList = (List)listResponseBody.getResult();
                }
                if (HospitalDepAdapter.this.hopitalList != null) {
                    HospitalDepAdapter.this.departmentEntities = ((MenuDepartmentList)HospitalDepAdapter.this.hopitalList.get(0)).getStandardSecondDepartmentList();
                }
                HospitalDepAdapter.this.flushView();
            }

            protected Context attachContext() {
                return mContext;
            }
        });
    }

    public HospitalDepAdapter(Context mContext) {
        this(mContext, true);
    }

    private List<MenuDepartmentList> parseHotDepartment(List<MenuDepartmentList> result) {
        MenuDepartmentList menuDepartmentList = new MenuDepartmentList();
        menuDepartmentList.setDisplayName("\u70ed\u95e8\u79d1\u5ba4");
        menuDepartmentList.setShortName("\u70ed\u95e8\u79d1\u5ba4");
        menuDepartmentList.setIconUrl("");
        menuDepartmentList.setRemark("remark");
        ArrayList<DepartmentEntity> departmentEntities = new ArrayList<DepartmentEntity>();
        DepartmentEntity departmentEntity = new DepartmentEntity();
        departmentEntity.setHospitalId(0);
        departmentEntity.setName("\u5168\u90e8\u79d1\u5ba4");
        departmentEntity.setStdSecondDepId(0);
        departmentEntity.setStdFirstDepId(0);
        departmentEntities.add(departmentEntity);
        menuDepartmentList.setStandardSecondDepartmentList(departmentEntities);
        result.add(0, menuDepartmentList);
        return result;
    }

    public int getLeftSize() {
        if (this.hopitalList == null) {
            return 0;
        }
        return this.hopitalList.size();
    }

    public int getRightSize() {
        if (this.departmentEntities == null) {
            return 0;
        }
        return this.departmentEntities.size();
    }

    @NotNull
    public View getLeftItem() {
        return View.inflate((Context)this.mContext, (int)R.layout.worktab_by_item_text_dep, null);
    }

    @NotNull
    public View getRightItem() {
        return View.inflate((Context)this.mContext, (int)R.layout.by_item_text_right, null);
    }

    public void leftDefaultStyle(View view) {
        if (view != null) {
            TextView textView = (TextView)view;
            textView.setTextColor(Color.parseColor((String)"#333333"));
            textView.setBackgroundColor(Color.parseColor((String)"#F4F4F4"));
        }
    }

    public void rightDefaultStyle(View view) {
        if (view != null) {
            TextView textView = (TextView)view.findViewById(R.id.vText);
            view.findViewById(R.id.vRightImage).setVisibility(4);
            textView.setTextColor(Color.parseColor((String)"#333333"));
        }
    }

    public void leftSelectedStyle(@NotNull View view) {
        TextView textView = (TextView)view;
        textView.setTextColor(Color.parseColor((String)"#3576E0"));
        textView.setBackgroundColor(Color.parseColor((String)"#ffffff"));
    }

    public void rightSelectedStyle(@NotNull View view) {
        view.findViewById(R.id.vRightImage).setVisibility(0);
        TextView textView = (TextView)view.findViewById(R.id.vText);
        textView.setTextColor(Color.parseColor((String)"#3576E0"));
    }

    public void fullRightView(int position, @Nullable List<? extends MenuDepartmentList> datas, @Nullable View view) {
        TextView textView = (TextView)view.findViewById(R.id.vText);
        textView.setTextColor(Color.parseColor((String)"#3576E0"));
        textView.setText((CharSequence)this.departmentEntities.get(position).getName());
        view.setTag((Object)(this.departmentEntities.get(position).getId() + ""));
    }

    public void fullLeftView(int position, @Nullable List<? extends MenuDepartmentList> datas, @Nullable View view) {
        TextView leftItem = (TextView)view;
        leftItem.setText((CharSequence)this.hopitalList.get(position).getDisplayName());
        leftItem.setTag((Object)(this.hopitalList.get(position).getId() + ""));
    }

    public void updateRightEvent(int position) {
        this.departmentEntities = this.isStandardDepartment ? this.hopitalList.get(position).getStandardSecondDepartmentList() : this.hopitalList.get(position).getHospitalDepartmentList();
    }
}

