/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.kangxin.doctor.worktable.util.Utils;
import com.kangxin.doctor.worktable.widget.ExcelPanel;
import com.kangxin.doctor.worktable.widget.IOnExcelPanelListener;
import com.kangxin.doctor.worktable.widget.RecyclerViewAdapter;
import java.util.ArrayList;
import java.util.List;

public class MajorRecyclerViewAdapter<M>
extends RecyclerViewAdapter<M> {
    private Context context;
    protected int amountAxisY = 0;
    private List<String> list;
    private List<RecyclerView.Adapter> adapterList;
    private IOnExcelPanelListener excelPanelListener;
    protected RecyclerView.OnScrollListener onScrollListener;

    public MajorRecyclerViewAdapter(Context context, List<M> list, IOnExcelPanelListener excelPanelListener) {
        super(context, list);
        this.context = context;
        this.adapterList = new ArrayList<RecyclerView.Adapter>();
        this.excelPanelListener = excelPanelListener;
    }

    public void setOnScrollListener(RecyclerView.OnScrollListener onScrollListener) {
        this.onScrollListener = onScrollListener;
    }

    @Override
    public void setData(List<M> data) {
        super.setData(data == null ? null : (List)data.get(0));
        if (data != null) {
            if (this.list == null || this.list.size() >= data.size()) {
                this.list = new ArrayList<String>();
            }
            for (int i = this.list.size(); i < data.size(); ++i) {
                this.list.add("");
            }
        } else {
            this.list = null;
        }
    }

    @Override
    public RecyclerView.ViewHolder onCreateNormalViewHolder(ViewGroup parent, int viewType) {
        RecyclerView recyclerView = new RecyclerView(this.context);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.context);
        layoutManager.setOrientation(1);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        return new RecyclerViewViewHolder((View)recyclerView);
    }

    @Override
    public void onBindNormalViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (!(holder instanceof RecyclerViewViewHolder)) {
            return;
        }
        RecyclerViewViewHolder viewHolder = (RecyclerViewViewHolder)holder;
        ContentRecyclerAdapter contentRecyclerAdapter = new ContentRecyclerAdapter(this.context, position, this.excelPanelListener);
        this.adapterList.add(contentRecyclerAdapter);
        contentRecyclerAdapter.setData(this.list);
        viewHolder.recyclerView.setAdapter(contentRecyclerAdapter);
        viewHolder.recyclerView.removeOnScrollListener(this.onScrollListener);
        viewHolder.recyclerView.addOnScrollListener(this.onScrollListener);
        ExcelPanel.fastScrollVertical(this.amountAxisY, viewHolder.recyclerView);
    }

    public void setAmountAxisY(int amountAxisY) {
        this.amountAxisY = amountAxisY;
    }

    public void customNotifyDataSetChanged() {
        if (!Utils.isEmpty(this.adapterList)) {
            for (RecyclerView.Adapter adapter : this.adapterList) {
                adapter.notifyDataSetChanged();
            }
        }
    }

    static class ContentRecyclerAdapter<C>
    extends RecyclerViewAdapter<C> {
        private int verticalPosition;
        private IOnExcelPanelListener excelPanelListener;

        public ContentRecyclerAdapter(Context context, int verticalPosition, IOnExcelPanelListener excelPanelListener) {
            super(context);
            this.verticalPosition = verticalPosition;
            this.excelPanelListener = excelPanelListener;
        }

        @Override
        public int getItemViewType(int position) {
            int viewType = super.getItemViewType(position);
            if (viewType == 2) {
                viewType = this.excelPanelListener.getCellItemViewType(position, this.verticalPosition);
            }
            return viewType;
        }

        @Override
        public RecyclerView.ViewHolder onCreateNormalViewHolder(ViewGroup parent, int viewType) {
            if (this.excelPanelListener != null) {
                return this.excelPanelListener.onCreateCellViewHolder(parent, viewType);
            }
            return null;
        }

        @Override
        public void onBindNormalViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (this.excelPanelListener != null) {
                this.excelPanelListener.onBindCellViewHolder(holder, position, this.verticalPosition);
            }
        }
    }

    static class RecyclerViewViewHolder
    extends RecyclerView.ViewHolder {
        public final RecyclerView recyclerView;

        public RecyclerViewViewHolder(View itemView) {
            super(itemView);
            this.recyclerView = (RecyclerView)itemView;
        }
    }
}

