/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import com.kangxin.doctor.worktable.R;

public class PatientAgressDialog
extends DialogFragment {
    ImageView vCancle;
    TextView vCommit;
    TextView vBook;
    View.OnClickListener clickListener;
    String mHospitalName;

    public static PatientAgressDialog newInstance(String mHospitalName, String diaName) {
        PatientAgressDialog patientAgressDialog = new PatientAgressDialog();
        patientAgressDialog.mHospitalName = mHospitalName;
        Bundle bundle = new Bundle();
        bundle.putString("mHospitalName", mHospitalName);
        bundle.putString("mDiaName", diaName);
        patientAgressDialog.setArguments(bundle);
        return patientAgressDialog;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = View.inflate((Context)inflater.getContext(), (int)R.layout.by_dialog_fragment_patient_agree, null);
        this.vCancle = (ImageView)view.findViewById(R.id.vCancle);
        this.vCommit = (TextView)view.findViewById(R.id.vCommit);
        this.vBook = (TextView)view.findViewById(R.id.vBook);
        return view;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.getDialog().getWindow().setLayout(-1, -1);
        this.init();
    }

    public void setOnClickListener(View.OnClickListener clickListener) {
        this.clickListener = clickListener;
    }

    private void init() {
        assert (this.getArguments() != null);
        this.mHospitalName = this.getArguments().getString("mHospitalName");
        String diaName = this.getArguments().getString("mDiaName");
        String bookFormat = this.getResources().getString(R.string.agree_book);
        bookFormat = String.format(bookFormat, this.mHospitalName, diaName);
        this.vBook.setText((CharSequence)bookFormat);
        this.vCancle.setOnClickListener(v -> this.dismiss());
        this.vCommit.setOnClickListener(v -> {
            if (this.clickListener != null) {
                this.clickListener.onClick(v);
                this.dismiss();
            }
        });
    }
}

