/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.widget.WheelListView;
import java.util.List;

public class WheelDialog
extends Dialog {
    private WheelListView wl_wheelView;
    private TextView tv_cancel;
    private TextView tv_success;
    private OnWheelSelectListener listener;

    @SuppressLint(value={"PrivateResource"})
    public WheelDialog(@NonNull Context context) {
        super(context, R.style.Base_Theme_AppCompat_Dialog);
        this.initView(context);
        this.initListener();
    }

    private void initView(Context context) {
        View rootView = View.inflate((Context)this.getContext(), (int)R.layout.worktab_by_dialog_widget_wheel, null);
        this.wl_wheelView = (WheelListView)rootView.findViewById(R.id.wl_wheelView);
        this.tv_cancel = (TextView)rootView.findViewById(R.id.tv_cancel);
        this.tv_success = (TextView)rootView.findViewById(R.id.tv_success);
        this.setContentView(rootView);
        Window window = this.getWindow();
        if (window != null) {
            window.setBackgroundDrawable((Drawable)new ColorDrawable(Color.argb((int)0, (int)0, (int)0, (int)0)));
            WindowManager.LayoutParams params = window.getAttributes();
            params.gravity = 81;
            WindowManager manager = (WindowManager)context.getSystemService("window");
            window.getDecorView().setPadding(0, 0, 0, 0);
            DisplayMetrics dm = new DisplayMetrics();
            manager.getDefaultDisplay().getMetrics(dm);
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.width = -1;
            lp.height = -2;
            window.setAttributes(lp);
        }
    }

    private void initListener() {
        this.tv_cancel.setOnClickListener(v -> this.dismiss());
        this.tv_success.setOnClickListener(v -> {
            String selectLabel = this.wl_wheelView.getSelectLabel();
            if (this.listener != null) {
                this.listener.onClickOk(this.wl_wheelView.getSelectIndex(), selectLabel);
            }
        });
    }

    public void setLabels(List<String> labels) {
        this.wl_wheelView.setLabels(labels);
    }

    public void setOnWheelSelectListener(OnWheelSelectListener listener) {
        this.listener = listener;
    }

    public static interface OnWheelSelectListener {
        public void onClickOk(int var1, String var2);
    }
}

