/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.google.android.cameraview.BaseCameraView;
import com.google.android.cameraview.CameraView;
import com.google.android.cameraview.R;
import org.jetbrains.annotations.NotNull;

public class ByFaceCameraView
extends BaseCameraView
implements View.OnClickListener {
    PictorBack back;
    private ImageView bt;

    public ByFaceCameraView(Context context) {
        super(context);
        this.init();
    }

    public ByFaceCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ByFaceCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setFacing(1);
    }

    @Override
    public void onPictureTake(@NotNull CameraView camera, @NotNull byte[] data) {
        this.openTakePictureAnim();
        if (this.back != null) {
            this.back.onBack(data);
        }
    }

    @Override
    public void onCameraOpen(@NotNull CameraView camera) {
        this.openTakePictureAnim();
    }

    public void onClick(View v) {
        this.closeTakePictureAnim();
        this.takePicture();
    }

    public void regTakePictorBack(PictorBack back) {
        this.back = back;
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    @NotNull
    public View provideFloorView() {
        ViewGroup rootView = (ViewGroup)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.by_face_layout, (ViewGroup)this, false);
        ImageView bg = (ImageView)rootView.findViewById(R.id.face_bg);
        Glide.with((View)this).load(Integer.valueOf(R.drawable.ic_camera_face_bg)).into(bg);
        this.bt = (ImageView)rootView.findViewById(R.id.face_bt);
        this.bt.setOnClickListener((View.OnClickListener)this);
        this.bt.setOnTouchListener((v, event) -> {
            if (event.getAction() == 0) {
                this.bt.animate().scaleX(1.2f).scaleY(1.2f).setDuration(100L).start();
            }
            if (event.getAction() == 1) {
                this.bt.animate().scaleY(1.0f).scaleX(1.0f).setDuration(100L).start();
            }
            return false;
        });
        return rootView;
    }

    public void openTakePictureAnim() {
        this.bt.setEnabled(true);
        this.bt.animate().scaleX(1.0f).scaleY(1.0f).setDuration(100L).start();
    }

    public void closeTakePictureAnim() {
        this.bt.setEnabled(false);
        this.bt.animate().scaleX(1.2f).scaleY(1.2f).setDuration(100L).start();
    }

    public static interface PictorBack {
        public void onBack(byte[] var1);
    }
}

