/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing;

import com.ailiwean.core.zxing.QRTypeConfig;
import com.ailiwean.core.zxing.ScanTypeConfig;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.aztec.AztecReader;
import com.google.zxing.datamatrix.DataMatrixReader;
import com.google.zxing.maxicode.MaxiCodeReader;
import com.google.zxing.oned.MultiFormatOneDReader;
import com.google.zxing.pdf417.PDF417Reader;
import com.google.zxing.qrcode.QRCodeReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class CustomMultiFormatReader
implements Reader {
    private Map<DecodeHintType, ?> hints;
    private Reader[] readers;
    private ScanTypeConfig mBarcodeType;

    public Result decode(BinaryBitmap image) {
        try {
            return this.decodeInternal(image);
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException {
        return this.decodeInternal(image);
    }

    public Result decodeWithState(BinaryBitmap image) throws NotFoundException {
        if (this.readers == null) {
            this.setHints(null);
        }
        return this.decodeInternal(image);
    }

    public void setHints(Map<DecodeHintType, ?> hints) {
        boolean tryHarder = hints != null && hints.containsKey(DecodeHintType.TRY_HARDER);
        Collection formats = hints == null ? null : (Collection)hints.get(DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<Object> readers = new ArrayList<Object>();
        if (formats != null) {
            boolean addOneDReader;
            boolean bl = addOneDReader = formats.contains(BarcodeFormat.UPC_A) || formats.contains(BarcodeFormat.UPC_E) || formats.contains(BarcodeFormat.EAN_13) || formats.contains(BarcodeFormat.EAN_8) || formats.contains(BarcodeFormat.CODABAR) || formats.contains(BarcodeFormat.CODE_39) || formats.contains(BarcodeFormat.CODE_93) || formats.contains(BarcodeFormat.CODE_128) || formats.contains(BarcodeFormat.ITF) || formats.contains(BarcodeFormat.RSS_14) || formats.contains(BarcodeFormat.RSS_EXPANDED);
            if (addOneDReader && !tryHarder) {
                readers.add(new MultiFormatOneDReader(hints));
            }
            if (formats.contains(BarcodeFormat.QR_CODE)) {
                readers.add(new QRCodeReader());
            }
            if (formats.contains(BarcodeFormat.DATA_MATRIX)) {
                readers.add(new DataMatrixReader());
            }
            if (formats.contains(BarcodeFormat.AZTEC)) {
                readers.add(new AztecReader());
            }
            if (formats.contains(BarcodeFormat.PDF_417)) {
                readers.add(new PDF417Reader());
            }
            if (formats.contains(BarcodeFormat.MAXICODE)) {
                readers.add(new MaxiCodeReader());
            }
            if (addOneDReader && tryHarder) {
                readers.add(new MultiFormatOneDReader(hints));
            }
        }
        if (readers.isEmpty()) {
            if (!tryHarder) {
                readers.add(new MultiFormatOneDReader(hints));
            }
            readers.add(new QRCodeReader());
            readers.add(new DataMatrixReader());
            readers.add(new AztecReader());
            readers.add(new PDF417Reader());
            readers.add(new MaxiCodeReader());
            if (tryHarder) {
                readers.add(new MultiFormatOneDReader(hints));
            }
        }
        this.readers = readers.toArray(new Reader[readers.size()]);
    }

    public void reset() {
        if (this.readers != null) {
            for (Reader reader : this.readers) {
                reader.reset();
            }
        }
    }

    private Result decodeInternal(BinaryBitmap image) throws NotFoundException {
        if (this.readers != null) {
            for (Reader reader : this.readers) {
                try {
                    return reader.decode(image, this.hints);
                }
                catch (ReaderException readerException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public void setType(ScanTypeConfig barcodeType, Map<DecodeHintType, Object> hintMap) {
        this.mBarcodeType = barcodeType;
        this.hints = hintMap;
        if (barcodeType == ScanTypeConfig.CUSTOM && (hintMap == null || hintMap.isEmpty())) {
            throw new RuntimeException("barcodeType \u4e3a BarcodeType.CUSTOM \u65f6 hintMap \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.setupReader();
    }

    protected void setupReader() {
        if (this.mBarcodeType == ScanTypeConfig.ONE_DIMENSION) {
            this.setHints(QRTypeConfig.ONE_DIMENSION_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.TWO_DIMENSION) {
            this.setHints(QRTypeConfig.TWO_DIMENSION_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.ONLY_QR_CODE) {
            this.setHints(QRTypeConfig.QR_CODE_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.ONLY_CODE_128) {
            this.setHints(QRTypeConfig.CODE_128_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.ONLY_EAN_13) {
            this.setHints(QRTypeConfig.EAN_13_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.HIGH_FREQUENCY) {
            this.setHints(QRTypeConfig.HIGH_FREQUENCY_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.CUSTOM) {
            this.setHints(this.hints);
        } else {
            this.setHints(QRTypeConfig.ALL_HINT_MAP);
        }
    }

    public static CustomMultiFormatReader getInstance() {
        return Holder.INSTANCE;
    }

    private CustomMultiFormatReader() {
        this.setType(ScanTypeConfig.ALL, null);
    }

    private static class Holder {
        static CustomMultiFormatReader INSTANCE = new CustomMultiFormatReader();

        private Holder() {
        }
    }
}

