/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.cameraview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.view.SurfaceHolder;
import android.widget.Toast;
import androidx.collection.SparseArrayCompat;
import com.google.android.cameraview.AspectRatio;
import com.google.android.cameraview.CameraViewImpl;
import com.google.android.cameraview.Constants;
import com.google.android.cameraview.PreviewImpl;
import com.google.android.cameraview.Size;
import com.google.android.cameraview.SizeMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;

class Camera1
extends CameraViewImpl {
    private static final int INVALID_CAMERA_ID = -1;
    private static final SparseArrayCompat<String> FLASH_MODES = new SparseArrayCompat();
    private int mCameraId;
    private final AtomicBoolean isPictureCaptureInProgress = new AtomicBoolean(false);
    Camera mCamera;
    private Camera.Parameters mCameraParameters;
    private final Camera.CameraInfo mCameraInfo = new Camera.CameraInfo();
    private final SizeMap mPreviewSizes = new SizeMap();
    private final SizeMap mPictureSizes = new SizeMap();
    private AspectRatio mAspectRatio;
    private boolean mShowingPreview;
    private boolean mAutoFocus;
    private int mFacing;
    private int mFlash;
    private int mDisplayOrientation;

    Camera1(CameraViewImpl.Callback callback, PreviewImpl preview) {
        super(callback, preview);
        preview.setCallback(new PreviewImpl.Callback(){

            @Override
            public void onSurfaceChanged() {
                if (Camera1.this.mCamera != null) {
                    Camera1.this.setUpPreview();
                    Camera1.this.adjustCameraParameters();
                }
            }
        });
    }

    @Override
    boolean start() {
        this.chooseCamera();
        this.openCamera();
        if (this.mPreview.isReady()) {
            this.setUpPreview();
        }
        this.mShowingPreview = true;
        if (this.mCamera != null) {
            this.mCamera.startPreview();
        }
        return true;
    }

    @Override
    void stop() {
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
        }
        this.mShowingPreview = false;
        this.releaseCamera();
    }

    @SuppressLint(value={"NewApi"})
    void setUpPreview() {
        try {
            if (this.mPreview.getOutputClass() == SurfaceHolder.class) {
                this.mCamera.setPreviewDisplay(this.mPreview.getSurfaceHolder());
            } else {
                this.mCamera.setPreviewTexture((SurfaceTexture)this.mPreview.getSurfaceTexture());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    boolean isCameraOpened() {
        return this.mCamera != null;
    }

    @Override
    void setFacing(int facing) {
        if (this.mFacing == facing) {
            return;
        }
        this.mFacing = facing;
        if (this.isCameraOpened()) {
            this.stop();
            this.start();
        }
    }

    @Override
    int getFacing() {
        return this.mFacing;
    }

    @Override
    Set<AspectRatio> getSupportedAspectRatios() {
        SizeMap idealAspectRatios = this.mPreviewSizes;
        for (AspectRatio aspectRatio : idealAspectRatios.ratios()) {
            if (this.mPictureSizes.sizes(aspectRatio) != null) continue;
            idealAspectRatios.remove(aspectRatio);
        }
        return idealAspectRatios.ratios();
    }

    @Override
    boolean setAspectRatio(AspectRatio ratio) {
        if (this.mAspectRatio == null || !this.isCameraOpened()) {
            this.mAspectRatio = ratio;
            return true;
        }
        if (!this.mAspectRatio.equals(ratio)) {
            SortedSet<Size> sizes = this.mPreviewSizes.sizes(ratio);
            if (sizes == null) {
                throw new UnsupportedOperationException(ratio + " is not supported");
            }
            this.mAspectRatio = ratio;
            this.adjustCameraParameters();
            return true;
        }
        return false;
    }

    @Override
    AspectRatio getAspectRatio() {
        return this.mAspectRatio;
    }

    @Override
    void setAutoFocus(boolean autoFocus) {
        if (this.mAutoFocus == autoFocus) {
            return;
        }
        if (this.setAutoFocusInternal(autoFocus)) {
            this.mCamera.setParameters(this.mCameraParameters);
        }
    }

    @Override
    boolean getAutoFocus() {
        if (!this.isCameraOpened()) {
            return this.mAutoFocus;
        }
        String focusMode = this.mCameraParameters.getFocusMode();
        return focusMode != null && focusMode.contains("continuous");
    }

    @Override
    void setFlash(int flash) {
        if (flash == this.mFlash) {
            return;
        }
        if (this.setFlashInternal(flash)) {
            this.mCamera.setParameters(this.mCameraParameters);
        }
    }

    @Override
    int getFlash() {
        return this.mFlash;
    }

    @Override
    void takePicture() {
        if (!this.isCameraOpened()) {
            throw new IllegalStateException("Camera is not ready. Call start() before takePicture().");
        }
        if (this.getAutoFocus()) {
            this.mCamera.cancelAutoFocus();
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                    Camera1.this.takePictureInternal();
                }
            });
        } else {
            this.takePictureInternal();
        }
    }

    void takePictureInternal() {
        if (!this.isPictureCaptureInProgress.getAndSet(true)) {
            this.mCamera.takePicture(null, null, null, new Camera.PictureCallback(){

                public void onPictureTaken(byte[] data, Camera camera) {
                    Camera1.this.isPictureCaptureInProgress.set(false);
                    Camera1.this.mCallback.onPictureTaken(data);
                    camera.cancelAutoFocus();
                    camera.startPreview();
                }
            });
        }
    }

    @Override
    void setDisplayOrientation(int displayOrientation) {
        if (this.mDisplayOrientation == displayOrientation) {
            return;
        }
        this.mDisplayOrientation = displayOrientation;
        if (this.isCameraOpened()) {
            this.mCameraParameters.setRotation(this.calcCameraRotation(displayOrientation));
            this.mCamera.setParameters(this.mCameraParameters);
            this.mCamera.setDisplayOrientation(this.calcDisplayOrientation(displayOrientation));
        }
    }

    @Override
    void toZoomMax() {
    }

    @Override
    void toZoomMin() {
    }

    @Override
    void setZoom(float percent) {
    }

    private void chooseCamera() {
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)this.mCameraInfo);
            if (this.mCameraInfo.facing != this.mFacing) continue;
            this.mCameraId = i;
            return;
        }
        this.mCameraId = -1;
    }

    private void openCamera() {
        if (this.mCamera != null) {
            this.releaseCamera();
        }
        try {
            this.mCamera = Camera.open((int)this.mCameraId);
        }
        catch (Exception e) {
            Toast.makeText((Context)this.getView().getContext(), (CharSequence)"\u6444\u50cf\u5934\u635f\u574f", (int)0).show();
            return;
        }
        if (this.mCamera == null) {
            Toast.makeText((Context)this.getView().getContext(), (CharSequence)"\u6444\u50cf\u5934\u635f\u574f", (int)0).show();
            return;
        }
        this.mCameraParameters = this.mCamera.getParameters();
        this.mPreviewSizes.clear();
        for (Camera.Size size : this.mCameraParameters.getSupportedPreviewSizes()) {
            this.mPreviewSizes.add(new Size(size.width, size.height));
        }
        this.mPictureSizes.clear();
        for (Camera.Size size : this.mCameraParameters.getSupportedPictureSizes()) {
            this.mPictureSizes.add(new Size(size.width, size.height));
        }
        if (this.mAspectRatio == null) {
            this.mAspectRatio = Constants.DEFAULT_ASPECT_RATIO;
        }
        this.adjustCameraParameters();
        this.mCamera.setDisplayOrientation(this.calcDisplayOrientation(this.mDisplayOrientation));
        this.mCallback.onCameraOpened();
    }

    private AspectRatio chooseAspectRatio() {
        AspectRatio r = null;
        Iterator<AspectRatio> iterator = this.mPreviewSizes.ratios().iterator();
        while (iterator.hasNext()) {
            AspectRatio ratio;
            r = ratio = iterator.next();
            if (!ratio.equals(Constants.DEFAULT_ASPECT_RATIO)) continue;
            return ratio;
        }
        return r;
    }

    void adjustCameraParameters() {
        SortedSet<Size> sizes = this.mPreviewSizes.sizes(this.mAspectRatio);
        if (sizes == null) {
            this.mAspectRatio = this.chooseAspectRatio();
            sizes = this.mPreviewSizes.sizes(this.mAspectRatio);
        }
        Size size = this.chooseOptimalSize(sizes);
        Size pictureSize = this.mPictureSizes.sizes(this.mAspectRatio).last();
        if (this.mShowingPreview) {
            this.mCamera.stopPreview();
        }
        this.mPreview.setBufferSize(size.getWidth(), size.getHeight());
        this.mCameraParameters.setPreviewSize(size.getWidth(), size.getHeight());
        this.mCameraParameters.setPictureSize(pictureSize.getWidth(), pictureSize.getHeight());
        this.mCameraParameters.setRotation(this.calcCameraRotation(this.mDisplayOrientation));
        this.setAutoFocusInternal(this.mAutoFocus);
        this.setFlashInternal(this.mFlash);
        this.mCamera.setParameters(this.mCameraParameters);
        if (this.mShowingPreview) {
            this.mCamera.startPreview();
        }
    }

    private Size chooseOptimalSize(SortedSet<Size> sizes) {
        int desiredHeight;
        int desiredWidth;
        if (!this.mPreview.isReady()) {
            return sizes.first();
        }
        int surfaceWidth = this.mPreview.getWidth();
        int surfaceHeight = this.mPreview.getHeight();
        if (this.isLandscape(this.mDisplayOrientation)) {
            desiredWidth = surfaceHeight;
            desiredHeight = surfaceWidth;
        } else {
            desiredWidth = surfaceWidth;
            desiredHeight = surfaceHeight;
        }
        Size result = null;
        for (Size size : sizes) {
            if (desiredWidth <= size.getWidth() && desiredHeight <= size.getHeight()) {
                return size;
            }
            result = size;
        }
        return result;
    }

    private void releaseCamera() {
        if (this.mCamera != null) {
            this.mCamera.release();
            this.mCamera = null;
            this.mCallback.onCameraClosed();
        }
    }

    private int calcDisplayOrientation(int screenOrientationDegrees) {
        if (this.mCameraInfo.facing == 1) {
            return (360 - (this.mCameraInfo.orientation + screenOrientationDegrees) % 360) % 360;
        }
        return (this.mCameraInfo.orientation - screenOrientationDegrees + 360) % 360;
    }

    private int calcCameraRotation(int screenOrientationDegrees) {
        if (this.mCameraInfo.facing == 1) {
            return (this.mCameraInfo.orientation + screenOrientationDegrees) % 360;
        }
        int landscapeFlip = this.isLandscape(screenOrientationDegrees) ? 180 : 0;
        return (this.mCameraInfo.orientation + screenOrientationDegrees + landscapeFlip) % 360;
    }

    private boolean isLandscape(int orientationDegrees) {
        return orientationDegrees == 90 || orientationDegrees == 270;
    }

    private boolean setAutoFocusInternal(boolean autoFocus) {
        this.mAutoFocus = autoFocus;
        if (this.isCameraOpened()) {
            List modes = this.mCameraParameters.getSupportedFocusModes();
            if (autoFocus && modes.contains("continuous-picture")) {
                this.mCameraParameters.setFocusMode("continuous-picture");
            } else if (modes.contains("fixed")) {
                this.mCameraParameters.setFocusMode("fixed");
            } else if (modes.contains("infinity")) {
                this.mCameraParameters.setFocusMode("infinity");
            } else {
                this.mCameraParameters.setFocusMode((String)modes.get(0));
            }
            return true;
        }
        return false;
    }

    private boolean setFlashInternal(int flash) {
        if (this.isCameraOpened()) {
            List modes = this.mCameraParameters.getSupportedFlashModes();
            String mode = (String)FLASH_MODES.get(flash);
            if (modes != null && modes.contains(mode)) {
                this.mCameraParameters.setFlashMode(mode);
                this.mFlash = flash;
                return true;
            }
            String currentMode = (String)FLASH_MODES.get(this.mFlash);
            if (modes == null || !modes.contains(currentMode)) {
                this.mCameraParameters.setFlashMode("off");
                this.mFlash = 0;
                return true;
            }
            return false;
        }
        this.mFlash = flash;
        return false;
    }

    static {
        FLASH_MODES.put(0, (Object)"off");
        FLASH_MODES.put(1, (Object)"on");
        FLASH_MODES.put(2, (Object)"torch");
        FLASH_MODES.put(3, (Object)"auto");
        FLASH_MODES.put(4, (Object)"red-eye");
    }
}

