/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.cameraview;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.ailiwean.core.Camera2Utils;
import com.ailiwean.core.WorkThreadServer;
import com.google.android.cameraview.AspectRatio;
import com.google.android.cameraview.CameraViewImpl;
import com.google.android.cameraview.Constants;
import com.google.android.cameraview.PreviewImpl;
import com.google.android.cameraview.Size;
import com.google.android.cameraview.SizeMap;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Set;
import java.util.SortedSet;

@TargetApi(value=21)
class Camera2
extends CameraViewImpl {
    private static final String TAG = "Camera2";
    private static final SparseIntArray INTERNAL_FACINGS = new SparseIntArray();
    private static final int MAX_PREVIEW_WIDTH = 1920;
    private static final int MAX_PREVIEW_HEIGHT = 1080;
    private final CameraManager mCameraManager;
    private final CameraDevice.StateCallback mCameraDeviceCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice camera) {
            Camera2.this.mCamera = camera;
            Camera2.this.mCallback.onCameraOpened();
            Camera2.this.startCaptureSession();
        }

        public void onClosed(@NonNull CameraDevice camera) {
            Camera2.this.mCallback.onCameraClosed();
        }

        public void onDisconnected(@NonNull CameraDevice camera) {
            Camera2.this.mCamera = null;
        }

        public void onError(@NonNull CameraDevice camera, int error) {
            Log.e((String)Camera2.TAG, (String)("onError: " + camera.getId() + " (" + error + ")"));
            Camera2.this.mCamera = null;
        }
    };
    private final CameraCaptureSession.StateCallback mSessionCallback = new CameraCaptureSession.StateCallback(){

        public void onConfigured(@NonNull CameraCaptureSession session) {
            if (Camera2.this.mCamera == null) {
                return;
            }
            Camera2.this.mCaptureSession = session;
            Camera2.this.updateAutoFocus();
            Camera2.this.updateFlash();
            try {
                Camera2.this.mCaptureSession.setRepeatingRequest(Camera2.this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)Camera2.this.mCaptureCallback, WorkThreadServer.getInstance().getBgHandle());
            }
            catch (CameraAccessException e) {
                Log.e((String)Camera2.TAG, (String)"Failed to start camera preview because it couldn't access camera", (Throwable)e);
            }
            catch (IllegalStateException e) {
                Log.e((String)Camera2.TAG, (String)"Failed to start camera preview.", (Throwable)e);
            }
        }

        public void onConfigureFailed(@NonNull CameraCaptureSession session) {
            Log.e((String)Camera2.TAG, (String)"Failed to configure capture session.");
        }

        public void onClosed(@NonNull CameraCaptureSession session) {
            if (Camera2.this.mCaptureSession != null && Camera2.this.mCaptureSession.equals(session)) {
                Camera2.this.mCaptureSession = null;
            }
        }
    };
    PictureCaptureCallback mCaptureCallback = new PictureCaptureCallback(){

        @Override
        public void onPrecaptureRequired() {
            Camera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.setState(3);
            try {
                Camera2.this.mCaptureSession.capture(Camera2.this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this, WorkThreadServer.getInstance().getBgHandle());
                Camera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)0);
            }
            catch (CameraAccessException e) {
                Log.e((String)Camera2.TAG, (String)"Failed to run precapture sequence.", (Throwable)e);
            }
        }

        @Override
        public void onReady() {
            Camera2.this.captureStillPicture();
        }
    };
    private final ImageReader.OnImageAvailableListener mOnImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            try (Image image = reader.acquireNextImage();){
                Image.Plane[] planes = image.getPlanes();
                if (planes.length > 0) {
                    ByteBuffer buffer = planes[0].getBuffer();
                    byte[] data = new byte[buffer.remaining()];
                    buffer.get(data);
                    Camera2.this.mCallback.onPictureTaken(data);
                }
            }
        }
    };
    private String mCameraId;
    private CameraCharacteristics mCameraCharacteristics;
    CameraDevice mCamera;
    CameraCaptureSession mCaptureSession;
    CaptureRequest.Builder mPreviewRequestBuilder;
    private ImageReader mImageReader;
    private ImageReader mYuvReader;
    private final SizeMap mPreviewSizes = new SizeMap();
    private final SizeMap mPictureSizes = new SizeMap();
    private int mFacing;
    private AspectRatio mAspectRatio = Constants.DEFAULT_ASPECT_RATIO;
    private boolean mAutoFocus;
    private int mFlash;
    private int mDisplayOrientation;
    private ImageReader.OnImageAvailableListener mOnYuvAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            Log.e((String)"thread", (String)(Thread.currentThread().getName() + ""));
            Camera2.this.mCallback.onPreviewByte(Camera2Utils.readYuv(reader));
        }
    };

    Camera2(CameraViewImpl.Callback callback, PreviewImpl preview, Context context) {
        super(callback, preview);
        this.mCameraManager = (CameraManager)context.getSystemService("camera");
        this.mPreview.setCallback(new PreviewImpl.Callback(){

            @Override
            public void onSurfaceChanged() {
                Camera2.this.startCaptureSession();
            }
        });
    }

    @Override
    boolean start() {
        if (!this.chooseCameraIdByFacing()) {
            return false;
        }
        this.collectCameraInfo();
        this.prepareImageReader();
        this.startOpeningCamera();
        return true;
    }

    @Override
    void stop() {
        if (this.mCamera != null) {
            this.mCamera.close();
            this.mCamera = null;
        }
        if (this.mCaptureSession != null) {
            this.mCaptureSession.close();
            this.mCaptureSession = null;
        }
        if (this.mImageReader != null) {
            this.mImageReader.close();
            this.mImageReader = null;
        }
        if (this.mYuvReader != null) {
            this.mYuvReader.close();
            this.mYuvReader = null;
        }
    }

    @Override
    boolean isCameraOpened() {
        return this.mCamera != null;
    }

    @Override
    void setFacing(int facing) {
        if (this.mFacing == facing) {
            return;
        }
        this.mFacing = facing;
        if (this.isCameraOpened()) {
            this.stop();
            this.start();
        }
    }

    @Override
    int getFacing() {
        return this.mFacing;
    }

    @Override
    Set<AspectRatio> getSupportedAspectRatios() {
        return this.mPreviewSizes.ratios();
    }

    @Override
    boolean setAspectRatio(AspectRatio ratio) {
        this.mAspectRatio = ratio;
        return true;
    }

    @Override
    AspectRatio getAspectRatio() {
        return this.mAspectRatio;
    }

    @Override
    void setAutoFocus(boolean autoFocus) {
        if (this.mAutoFocus == autoFocus) {
            return;
        }
        this.mAutoFocus = autoFocus;
        if (this.mPreviewRequestBuilder != null) {
            this.updateAutoFocus();
            if (this.mCaptureSession != null) {
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, WorkThreadServer.getInstance().getBgHandle());
                }
                catch (CameraAccessException e) {
                    this.mAutoFocus = !this.mAutoFocus;
                }
            }
        }
    }

    @Override
    boolean getAutoFocus() {
        return this.mAutoFocus;
    }

    @Override
    void setFlash(int flash) {
        if (this.mFlash == flash) {
            return;
        }
        int saved = this.mFlash;
        this.mFlash = flash;
        if (this.mPreviewRequestBuilder != null) {
            this.updateFlash();
            if (this.mCaptureSession != null) {
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, WorkThreadServer.getInstance().getBgHandle());
                }
                catch (CameraAccessException e) {
                    this.mFlash = saved;
                }
            }
        }
    }

    @Override
    int getFlash() {
        return this.mFlash;
    }

    @Override
    void takePicture() {
        if (this.mAutoFocus) {
            this.lockFocus();
        } else {
            this.captureStillPicture();
        }
    }

    @Override
    void setDisplayOrientation(int displayOrientation) {
        this.mDisplayOrientation = displayOrientation;
        this.mPreview.setDisplayOrientation(this.mDisplayOrientation);
    }

    @Override
    void toZoomMax() {
        try {
            this.mPreviewRequestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)Camera2Utils.getZoomRect(this.mCameraCharacteristics, 1.0f));
            this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, WorkThreadServer.getInstance().getBgHandle());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    void toZoomMin() {
        try {
            this.mPreviewRequestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)Camera2Utils.getZoomRect(this.mCameraCharacteristics, 0.0f));
            this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, WorkThreadServer.getInstance().getBgHandle());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    void setZoom(float percent) {
        try {
            this.mPreviewRequestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)Camera2Utils.getZoomRect(this.mCameraCharacteristics, percent));
            this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, WorkThreadServer.getInstance().getBgHandle());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean chooseCameraIdByFacing() {
        try {
            int internalFacing = INTERNAL_FACINGS.get(this.mFacing);
            String[] ids = this.mCameraManager.getCameraIdList();
            if (ids.length == 0) {
                throw new RuntimeException("No camera available.");
            }
            for (String id2 : ids) {
                CameraCharacteristics characteristics = this.mCameraManager.getCameraCharacteristics(id2);
                Integer level = (Integer)characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                if (level == null || level == 2) continue;
                Integer internal = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (internal == null) {
                    throw new NullPointerException("Unexpected state: LENS_FACING null");
                }
                if (internal != internalFacing) continue;
                this.mCameraId = id2;
                this.mCameraCharacteristics = characteristics;
                return true;
            }
            this.mCameraId = ids[0];
            this.mCameraCharacteristics = this.mCameraManager.getCameraCharacteristics(this.mCameraId);
            Integer level = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            if (level == null || level == 2) {
                return false;
            }
            Integer internal = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
            if (internal == null) {
                throw new NullPointerException("Unexpected state: LENS_FACING null");
            }
            int count = INTERNAL_FACINGS.size();
            for (int i = 0; i < count; ++i) {
                if (INTERNAL_FACINGS.valueAt(i) != internal.intValue()) continue;
                this.mFacing = INTERNAL_FACINGS.keyAt(i);
                return true;
            }
            this.mFacing = 0;
            return true;
        }
        catch (CameraAccessException e) {
            throw new RuntimeException("Failed to get a list of camera devices", e);
        }
    }

    private void collectCameraInfo() {
        StreamConfigurationMap map = (StreamConfigurationMap)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (map == null) {
            throw new IllegalStateException("Failed to get configuration map: " + this.mCameraId);
        }
        this.mPreviewSizes.clear();
        for (android.util.Size size : map.getOutputSizes(this.mPreview.getOutputClass())) {
            int width = size.getWidth();
            int height = size.getHeight();
            if (width > 1920 || height > 1080) continue;
            this.mPreviewSizes.add(new Size(width, height));
        }
        if (!this.mPreviewSizes.ratios().contains(this.mAspectRatio)) {
            this.mAspectRatio = Constants.DEFAULT_ASPECT_RATIO;
        }
        this.mPictureSizes.clear();
        this.collectPictureSizes(this.mPictureSizes, map);
        for (AspectRatio ratio : this.mPreviewSizes.ratios()) {
            if (this.mPictureSizes.ratios().contains(ratio)) continue;
            this.mPreviewSizes.remove(ratio);
        }
        if (!this.mPreviewSizes.ratios().contains(this.mAspectRatio)) {
            this.mAspectRatio = this.mPreviewSizes.ratios().iterator().next();
        }
    }

    protected void collectPictureSizes(SizeMap sizes, StreamConfigurationMap map) {
        for (android.util.Size size : map.getOutputSizes(256)) {
            this.mPictureSizes.add(new Size(size.getWidth(), size.getHeight()));
        }
    }

    private void prepareImageReader() {
        if (this.mImageReader != null) {
            this.mImageReader.close();
        }
        Size largest = this.mPictureSizes.sizes(this.mAspectRatio).last();
        this.mImageReader = ImageReader.newInstance((int)largest.getWidth(), (int)largest.getHeight(), (int)256, (int)2);
        this.mImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, WorkThreadServer.getInstance().getBgHandle());
        Size prelargest = this.mPreviewSizes.sizes(this.mAspectRatio).last();
        this.mYuvReader = ImageReader.newInstance((int)prelargest.getWidth(), (int)prelargest.getHeight(), (int)35, (int)2);
        this.mYuvReader.setOnImageAvailableListener(this.mOnYuvAvailableListener, WorkThreadServer.getInstance().getBgHandle());
    }

    private void startOpeningCamera() {
        try {
            this.mCameraManager.openCamera(this.mCameraId, this.mCameraDeviceCallback, WorkThreadServer.getInstance().getBgHandle());
        }
        catch (CameraAccessException e) {
            throw new RuntimeException("Failed to open camera: " + this.mCameraId, e);
        }
    }

    void startCaptureSession() {
        if (!this.isCameraOpened() || !this.mPreview.isReady() || this.mImageReader == null) {
            return;
        }
        Size previewSize = this.chooseOptimalSize();
        this.mPreview.setBufferSize(previewSize.getWidth(), previewSize.getHeight());
        Surface surface = this.mPreview.getSurface();
        try {
            this.mPreviewRequestBuilder = this.mCamera.createCaptureRequest(1);
            this.mPreviewRequestBuilder.addTarget(surface);
            this.mPreviewRequestBuilder.addTarget(this.mYuvReader.getSurface());
            this.mCamera.createCaptureSession(Arrays.asList(surface, this.mImageReader.getSurface(), this.mYuvReader.getSurface()), this.mSessionCallback, WorkThreadServer.getInstance().getBgHandle());
        }
        catch (CameraAccessException e) {
            throw new RuntimeException("Failed to start camera session");
        }
    }

    private Size chooseOptimalSize() {
        int surfaceShorter;
        int surfaceLonger;
        int surfaceHeight;
        int surfaceWidth = this.mPreview.getWidth();
        if (surfaceWidth < (surfaceHeight = this.mPreview.getHeight())) {
            surfaceLonger = surfaceHeight;
            surfaceShorter = surfaceWidth;
        } else {
            surfaceLonger = surfaceWidth;
            surfaceShorter = surfaceHeight;
        }
        SortedSet<Size> candidates = this.mPreviewSizes.sizes(this.mAspectRatio);
        for (Size size : candidates) {
            if (size.getWidth() < surfaceLonger || size.getHeight() < surfaceShorter) continue;
            return size;
        }
        return candidates.last();
    }

    void updateAutoFocus() {
        if (this.mAutoFocus) {
            int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
            if (modes == null || modes.length == 0 || modes.length == 1 && modes[0] == 0) {
                this.mAutoFocus = false;
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            } else {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            }
        } else {
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
        }
    }

    void updateFlash() {
        switch (this.mFlash) {
            case 0: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case 1: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)3);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case 2: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                break;
            }
            case 3: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case 4: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)4);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            }
        }
    }

    private void lockFocus() {
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        try {
            this.mCaptureCallback.setState(1);
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, WorkThreadServer.getInstance().getBgHandle());
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)"Failed to lock focus.", (Throwable)e);
        }
    }

    void captureStillPicture() {
        try {
            CaptureRequest.Builder captureRequestBuilder = this.mCamera.createCaptureRequest(2);
            captureRequestBuilder.addTarget(this.mImageReader.getSurface());
            captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, this.mPreviewRequestBuilder.get(CaptureRequest.CONTROL_AF_MODE));
            switch (this.mFlash) {
                case 0: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                    break;
                }
                case 1: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)3);
                    break;
                }
                case 2: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                    break;
                }
                case 3: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                    break;
                }
                case 4: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                }
            }
            int sensorOrientation = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
            captureRequestBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)((sensorOrientation + this.mDisplayOrientation * (this.mFacing == 1 ? 1 : -1) + 360) % 360));
            this.mCaptureSession.stopRepeating();
            this.mCaptureSession.capture(captureRequestBuilder.build(), new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                    Camera2.this.unlockFocus();
                }
            }, WorkThreadServer.getInstance().getBgHandle());
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)"Cannot capture a still picture.", (Throwable)e);
        }
    }

    void unlockFocus() {
        if (!this.isCameraOpened()) {
            return;
        }
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
        try {
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, WorkThreadServer.getInstance().getBgHandle());
            this.updateAutoFocus();
            this.updateFlash();
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
            this.mCaptureCallback.setState(0);
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)"Failed to restart camera preview.", (Throwable)e);
        }
    }

    static {
        INTERNAL_FACINGS.put(0, 1);
        INTERNAL_FACINGS.put(1, 0);
    }

    private static abstract class PictureCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        static final int STATE_PREVIEW = 0;
        static final int STATE_LOCKING = 1;
        static final int STATE_LOCKED = 2;
        static final int STATE_PRECAPTURE = 3;
        static final int STATE_WAITING = 4;
        static final int STATE_CAPTURING = 5;
        private int mState;

        PictureCaptureCallback() {
        }

        void setState(int state) {
            this.mState = state;
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }

        private void process(@NonNull CaptureResult result) {
            switch (this.mState) {
                case 1: {
                    Integer af = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                    if (af == null || af != 4 && af != 5) break;
                    Integer ae = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (ae == null || ae == 2) {
                        this.setState(5);
                        this.onReady();
                        break;
                    }
                    this.setState(2);
                    this.onPrecaptureRequired();
                    break;
                }
                case 3: {
                    Integer ae = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (ae != null && ae != 5 && ae != 4 && ae != 2) break;
                    this.setState(4);
                    break;
                }
                case 4: {
                    Integer ae = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (ae != null && ae == 5) break;
                    this.setState(5);
                    this.onReady();
                    break;
                }
            }
        }

        public abstract void onReady();

        public abstract void onPrecaptureRequired();
    }
}

