/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.cameraview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.ailiwean.core.Config;
import com.google.android.cameraview.AspectRatio;
import com.google.android.cameraview.Camera1;
import com.google.android.cameraview.Camera2;
import com.google.android.cameraview.Camera2Api23;
import com.google.android.cameraview.CameraViewImpl;
import com.google.android.cameraview.Constants;
import com.google.android.cameraview.DisplayOrientationDetector;
import com.google.android.cameraview.PreviewImpl;
import com.google.android.cameraview.R;
import com.google.android.cameraview.TextureViewPreview;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Set;

public class CameraView
extends FrameLayout {
    public static final int FACING_BACK = 0;
    public static final int FACING_FRONT = 1;
    public static final int FLASH_OFF = 0;
    public static final int FLASH_ON = 1;
    public static final int FLASH_TORCH = 2;
    public static final int FLASH_AUTO = 3;
    public static final int FLASH_RED_EYE = 4;
    CameraViewImpl mImpl;
    private final CallbackBridge mCallbacks;
    private boolean mAdjustViewBounds;
    private final DisplayOrientationDetector mDisplayOrientationDetector;
    RectF r = new RectF();

    public CameraView(Context context) {
        this(context, null);
    }

    public CameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.isInEditMode()) {
            this.mCallbacks = null;
            this.mDisplayOrientationDetector = null;
            return;
        }
        PreviewImpl preview = this.createPreviewImpl(context);
        this.mCallbacks = new CallbackBridge();
        this.mImpl = Build.VERSION.SDK_INT < 21 ? new Camera1(this.mCallbacks, preview) : (Build.VERSION.SDK_INT < 23 ? new Camera2(this.mCallbacks, preview, context) : new Camera2Api23(this.mCallbacks, preview, context));
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CameraView, defStyleAttr, R.style.Widget_CameraView);
        this.mAdjustViewBounds = a.getBoolean(R.styleable.CameraView_android_adjustViewBounds, false);
        this.setFacing(a.getInt(R.styleable.CameraView_facing, 0));
        String aspectRatio = a.getString(R.styleable.CameraView_aspectRatio);
        if (aspectRatio != null) {
            this.setAspectRatio(AspectRatio.parse(aspectRatio));
        } else {
            this.setAspectRatio(Constants.DEFAULT_ASPECT_RATIO);
        }
        this.setAutoFocus(a.getBoolean(R.styleable.CameraView_autoFocus, true));
        this.setFlash(a.getInt(R.styleable.CameraView_flash, 3));
        a.recycle();
        this.mDisplayOrientationDetector = new DisplayOrientationDetector(context){

            @Override
            public void onDisplayOrientationChanged(int displayOrientation) {
                CameraView.this.mImpl.setDisplayOrientation(displayOrientation);
            }
        };
    }

    @NonNull
    private PreviewImpl createPreviewImpl(Context context) {
        TextureViewPreview preview = new TextureViewPreview(context, (ViewGroup)this);
        return preview;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.mDisplayOrientationDetector.enable(ViewCompat.getDisplay((View)this));
        }
    }

    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.mDisplayOrientationDetector.disable();
        }
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        AspectRatio ratio;
        if (this.isInEditMode()) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (this.mAdjustViewBounds) {
            if (!this.isCameraOpened()) {
                this.mCallbacks.reserveRequestLayoutOnOpen();
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            if (widthMode == 0x40000000 && heightMode != 0x40000000) {
                ratio = this.getAspectRatio();
                assert (ratio != null);
                int height = (int)((float)View.MeasureSpec.getSize((int)widthMeasureSpec) * ratio.toFloat());
                if (heightMode == Integer.MIN_VALUE) {
                    height = Math.min(height, View.MeasureSpec.getSize((int)heightMeasureSpec));
                }
                super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
            } else if (widthMode != 0x40000000 && heightMode == 0x40000000) {
                ratio = this.getAspectRatio();
                assert (ratio != null);
                int width = (int)((float)View.MeasureSpec.getSize((int)heightMeasureSpec) * ratio.toFloat());
                if (widthMode == Integer.MIN_VALUE) {
                    width = Math.min(width, View.MeasureSpec.getSize((int)widthMeasureSpec));
                }
                super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), heightMeasureSpec);
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        ratio = this.getAspectRatio();
        if (this.mDisplayOrientationDetector.getLastKnownDisplayOrientation() % 180 == 0) {
            ratio = ratio.inverse();
        }
        assert (ratio != null);
        if (height < width * ratio.getY() / ratio.getX()) {
            this.mImpl.getView().measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(width * ratio.getY() / ratio.getX()), (int)0x40000000));
            this.r.left = 0.0f;
            this.r.right = 1.0f;
            this.r.top = ((float)width * (float)ratio.getY() / (float)ratio.getX() - (float)height) / 2.0f / ((float)width * (float)ratio.getY() / (float)ratio.getX());
            this.r.bottom = 1.0f - this.r.top;
            Config.scanRect.setRect(this.r);
        } else {
            this.mImpl.getView().measure(View.MeasureSpec.makeMeasureSpec((int)(height * ratio.getX() / ratio.getY()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
            this.r.left = ((float)height * (float)ratio.getX() / (float)ratio.getY() - (float)width) / 2.0f / ((float)height * (float)ratio.getX() / (float)ratio.getY());
            this.r.right = 1.0f - this.r.left;
            this.r.top = 0.0f;
            this.r.bottom = 1.0f;
            Config.scanRect.setRect(this.r);
        }
    }

    protected Parcelable onSaveInstanceState() {
        SavedState state = new SavedState(super.onSaveInstanceState());
        state.facing = this.getFacing();
        state.ratio = this.getAspectRatio();
        state.autoFocus = this.getAutoFocus();
        state.flash = this.getFlash();
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setFacing(ss.facing);
        this.setAspectRatio(ss.ratio);
        this.setAutoFocus(ss.autoFocus);
        this.setFlash(ss.flash);
    }

    public void start() {
        if (!this.isCameraOpened() && !this.mImpl.start()) {
            Parcelable state = this.onSaveInstanceState();
            this.mImpl = new Camera1(this.mCallbacks, this.createPreviewImpl(this.getContext()));
            this.onRestoreInstanceState(state);
            this.mImpl.start();
        }
    }

    public void stop() {
        this.mImpl.stop();
    }

    public boolean isCameraOpened() {
        return this.mImpl.isCameraOpened();
    }

    public void addCallback(@NonNull Callback callback) {
        this.mCallbacks.add(callback);
    }

    public void removeCallback(@NonNull Callback callback) {
        this.mCallbacks.remove(callback);
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        if (this.mAdjustViewBounds != adjustViewBounds) {
            this.mAdjustViewBounds = adjustViewBounds;
            this.requestLayout();
        }
    }

    public boolean getAdjustViewBounds() {
        return this.mAdjustViewBounds;
    }

    public void setFacing(int facing) {
        this.mImpl.setFacing(facing);
    }

    public int getFacing() {
        return this.mImpl.getFacing();
    }

    public Set<AspectRatio> getSupportedAspectRatios() {
        return this.mImpl.getSupportedAspectRatios();
    }

    public void setAspectRatio(@NonNull AspectRatio ratio) {
        this.mImpl.setAspectRatio(ratio);
    }

    @Nullable
    public AspectRatio getAspectRatio() {
        return this.mImpl.getAspectRatio();
    }

    public void setAutoFocus(boolean autoFocus) {
        this.mImpl.setAutoFocus(autoFocus);
    }

    public boolean getAutoFocus() {
        return this.mImpl.getAutoFocus();
    }

    public void setFlash(@Flash int flash) {
        this.mImpl.setFlash(flash);
    }

    @Flash
    public int getFlash() {
        return this.mImpl.getFlash();
    }

    public void takePicture() {
        if (this.isCameraOpened()) {
            this.mImpl.takePicture();
        }
    }

    public static abstract class Callback {
        public void onCameraOpened(CameraView cameraView) {
        }

        public void onCameraClosed(CameraView cameraView) {
        }

        public void onPictureTaken(CameraView cameraView, byte[] data) {
        }

        public void onPreviewByte(CameraView cameraView, byte[] data) {
        }
    }

    protected static class SavedState
    extends View.BaseSavedState {
        int facing;
        AspectRatio ratio;
        boolean autoFocus;
        @Flash
        int flash;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return this.createFromParcel(in, null);
            }

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source, ClassLoader loader) {
            super(source);
            this.facing = source.readInt();
            this.ratio = (AspectRatio)source.readParcelable(loader);
            this.autoFocus = source.readByte() != 0;
            this.flash = source.readInt();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.facing);
            out.writeParcelable((Parcelable)this.ratio, 0);
            out.writeByte((byte)(this.autoFocus ? 1 : 0));
            out.writeInt(this.flash);
        }
    }

    private class CallbackBridge
    implements CameraViewImpl.Callback {
        private final ArrayList<Callback> mCallbacks = new ArrayList();
        private boolean mRequestLayoutOnOpen;

        CallbackBridge() {
        }

        public void add(Callback callback) {
            this.mCallbacks.add(callback);
        }

        public void remove(Callback callback) {
            this.mCallbacks.remove(callback);
        }

        @Override
        public void onCameraOpened() {
            if (this.mRequestLayoutOnOpen) {
                this.mRequestLayoutOnOpen = false;
                CameraView.this.requestLayout();
            }
            for (Callback callback : this.mCallbacks) {
                callback.onCameraOpened(CameraView.this);
            }
        }

        @Override
        public void onCameraClosed() {
            for (Callback callback : this.mCallbacks) {
                callback.onCameraClosed(CameraView.this);
            }
        }

        @Override
        public void onPreviewByte(byte[] data) {
            for (Callback callback : this.mCallbacks) {
                callback.onPreviewByte(CameraView.this, data);
            }
        }

        @Override
        public void onPictureTaken(byte[] data) {
            for (Callback callback : this.mCallbacks) {
                callback.onPictureTaken(CameraView.this, data);
            }
        }

        public void reserveRequestLayoutOnOpen() {
            this.mRequestLayoutOnOpen = true;
        }
    }

    public static @interface Flash {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Facing {
    }
}

