/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.cameraview;

import android.view.View;
import androidx.annotation.FloatRange;
import com.google.android.cameraview.AspectRatio;
import com.google.android.cameraview.PreviewImpl;
import java.util.Set;

abstract class CameraViewImpl {
    protected final Callback mCallback;
    protected final PreviewImpl mPreview;

    CameraViewImpl(Callback callback, PreviewImpl preview) {
        this.mCallback = callback;
        this.mPreview = preview;
    }

    View getView() {
        return this.mPreview.getView();
    }

    abstract boolean start();

    abstract void stop();

    abstract boolean isCameraOpened();

    abstract void setFacing(int var1);

    abstract int getFacing();

    abstract Set<AspectRatio> getSupportedAspectRatios();

    abstract boolean setAspectRatio(AspectRatio var1);

    abstract AspectRatio getAspectRatio();

    abstract void setAutoFocus(boolean var1);

    abstract boolean getAutoFocus();

    abstract void setFlash(int var1);

    abstract int getFlash();

    abstract void takePicture();

    abstract void setDisplayOrientation(int var1);

    abstract void toZoomMax();

    abstract void toZoomMin();

    abstract void setZoom(@FloatRange(from=0.0, to=1.0) float var1);

    static interface Callback {
        public void onCameraOpened();

        public void onCameraClosed();

        public void onPreviewByte(byte[] var1);

        public void onPictureTaken(byte[] var1);
    }
}

