/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core;

import android.os.Handler;
import android.os.HandlerThread;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WorkThreadServer {
    private HandlerThread handlerThread;
    private Handler handler;
    private ThreadPoolExecutor executor;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int corePoolSize = Math.max(2, Math.min(CPU_COUNT - 1, 4));
    private static final int maximumPoolSize = CPU_COUNT * 2 + 1;
    private static final int keepAliveTime = 30;

    private WorkThreadServer() {
    }

    public static WorkThreadServer getInstance() {
        if (Holder.INSTANCE.executor == null) {
            Holder.INSTANCE.executor = new ThreadPoolExecutor(corePoolSize, corePoolSize, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(maximumPoolSize, true), new ThreadPoolExecutor.DiscardOldestPolicy());
        }
        if (Holder.INSTANCE.handlerThread == null) {
            Holder.INSTANCE.handlerThread = new HandlerThread("Default");
            Holder.INSTANCE.handlerThread.start();
            Holder.INSTANCE.handler = new Handler(Holder.INSTANCE.handlerThread.getLooper());
        }
        return Holder.INSTANCE;
    }

    public Handler getBgHandle() {
        return this.handler;
    }

    public void post(Runnable runnable) {
        if (this.executor != null) {
            this.executor.execute(runnable);
        }
    }

    public void quit() {
        if (this.handler != null) {
            this.handlerThread.quit();
            this.handlerThread = null;
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    private static class Holder {
        static WorkThreadServer INSTANCE = new WorkThreadServer();

        private Holder() {
        }
    }
}

