/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.able;

import android.os.Handler;
import android.os.Message;
import com.ailiwean.core.Config;
import com.ailiwean.core.able.XQRScanAble;
import com.ailiwean.core.helper.ScanHelper;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.qrcode.detector.Detector;

public class XQRScanZoomAble
extends XQRScanAble {
    long zoomTime = 0L;

    XQRScanZoomAble(Handler handler) {
        super(handler);
    }

    @Override
    public void cusAction(byte[] data, int dataWidth, int dataHeight) {
        super.cusAction(data, dataWidth, dataHeight);
        DetectorResult decoderResult = null;
        try {
            decoderResult = new Detector(this.binaryBitmap.getBlackMatrix()).detect(null);
        }
        catch (FormatException | NotFoundException e) {
            e.printStackTrace();
        }
        if (decoderResult == null) {
            return;
        }
        ResultPoint[] points = decoderResult.getPoints();
        int lenght = ScanHelper.getQrLenght(points);
        if (lenght < Config.scanRect.getPreX() / 3 * 2) {
            if (System.currentTimeMillis() - this.zoomTime < 500L) {
                return;
            }
            Message.obtain((Handler)this.handler, (int)2, (Object)((double)Config.currentZoom + 0.05 + "")).sendToTarget();
            this.zoomTime = System.currentTimeMillis();
        }
    }
}

