/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.helper;

import android.graphics.Rect;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import androidx.annotation.FloatRange;

public class CameraHelper {
    public static boolean checkAutoFocus(CameraCharacteristics characteristics) {
        int[] afAvailableModes = new int[]{};
        if (Build.VERSION.SDK_INT >= 21) {
            afAvailableModes = (int[])characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        }
        return afAvailableModes.length != 0 && (afAvailableModes.length != 1 || afAvailableModes[0] != 0);
    }

    public void checkFocusMode(CameraCharacteristics cameraCharacteristics) {
        int[] availableFocusModes = new int[]{};
        if (Build.VERSION.SDK_INT >= 21) {
            availableFocusModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        }
        for (int focusMode : availableFocusModes != null ? availableFocusModes : new int[]{}) {
            if (focusMode != 0 && focusMode != 2 && focusMode != 4 && focusMode != 1) continue;
        }
    }

    public static boolean matchCameraDirection(CameraCharacteristics cameraCharacteristics, int direction) {
        Integer facing = null;
        if (Build.VERSION.SDK_INT >= 21) {
            facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        }
        return facing != null && facing == direction;
    }

    public static Float getMinimumFocusDistance(CameraCharacteristics cameraCharacteristics) {
        Float distance = null;
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                distance = (Float)cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return distance;
    }

    public static Float getMaxZoom(CameraCharacteristics cameraCharacteristics) {
        Float maxZoom = null;
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                maxZoom = (Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maxZoom;
    }

    public static Rect getZoomRect(CameraCharacteristics cameraCharacteristics, @FloatRange(from=0.0, to=1.0) float currentZoom) {
        Rect zoomRect;
        Float maxZoom;
        if ((currentZoom = currentZoom == 0.0f ? 1.0f : currentZoom * maxZoom.floatValue() + 1.0f) > (maxZoom = CameraHelper.getMaxZoom(cameraCharacteristics)).floatValue()) {
            currentZoom = maxZoom.floatValue();
        }
        if (currentZoom < 1.0f) {
            currentZoom = 1.0f;
        }
        Rect originReact = null;
        if (Build.VERSION.SDK_INT >= 21) {
            originReact = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        }
        try {
            if (originReact == null) {
                return null;
            }
            float ratio = 1.0f / currentZoom;
            int cropWidth = originReact.width() - Math.round((float)originReact.width() * ratio);
            int cropHeight = originReact.height() - Math.round((float)originReact.height() * ratio);
            zoomRect = new Rect(cropWidth / 2, cropHeight / 2, originReact.width() - cropWidth / 2, originReact.height() - cropHeight / 2);
        }
        catch (Exception e) {
            e.printStackTrace();
            zoomRect = null;
        }
        return zoomRect;
    }

    public static byte[] readYuv(ImageReader reader) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        Image image = null;
        image = reader.acquireLatestImage();
        if (image == null) {
            return null;
        }
        byte[] data = CameraHelper.getByteFromImage(image);
        image.close();
        return data;
    }

    private static byte[] getByteFromImage(Image image) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int i420Size = w * h * 3 / 2;
        Image.Plane[] planes = image.getPlanes();
        int remaining0 = planes[0].getBuffer().remaining();
        int remaining1 = planes[1].getBuffer().remaining();
        int remaining2 = planes[2].getBuffer().remaining();
        int pixelStride = planes[2].getPixelStride();
        int rowOffest = planes[2].getRowStride();
        byte[] nv21 = new byte[i420Size];
        byte[] yRawSrcBytes = new byte[remaining0];
        byte[] uRawSrcBytes = new byte[remaining1];
        byte[] vRawSrcBytes = new byte[remaining2];
        planes[0].getBuffer().get(yRawSrcBytes);
        planes[1].getBuffer().get(uRawSrcBytes);
        planes[2].getBuffer().get(vRawSrcBytes);
        if (pixelStride == w) {
            System.arraycopy(yRawSrcBytes, 0, nv21, 0, rowOffest * h);
            System.arraycopy(vRawSrcBytes, 0, nv21, rowOffest * h, rowOffest * h / 2 - 1);
        } else {
            byte[] ySrcBytes = new byte[w * h];
            byte[] vSrcBytes = new byte[w * h / 2 - 1];
            for (int row = 0; row < h; ++row) {
                System.arraycopy(yRawSrcBytes, rowOffest * row, ySrcBytes, w * row, w);
                if (row % 2 != 0) continue;
                if (row == h - 2) {
                    System.arraycopy(vRawSrcBytes, rowOffest * row / 2, vSrcBytes, w * row / 2, w - 1);
                    continue;
                }
                System.arraycopy(vRawSrcBytes, rowOffest * row / 2, vSrcBytes, w * row / 2, w);
            }
            System.arraycopy(ySrcBytes, 0, nv21, 0, w * h);
            System.arraycopy(vSrcBytes, 0, nv21, w * h, w * h / 2 - 1);
        }
        return nv21;
    }

    public static void setZoom(@FloatRange(from=0.0, to=1.0) float z, Camera mCamera) {
        if (mCamera == null) {
            return;
        }
        Camera.Parameters p = mCamera.getParameters();
        if (p == null) {
            return;
        }
        if (!p.isZoomSupported()) {
            return;
        }
        int zoom = (int)(z * (float)p.getMaxZoom());
        if (zoom < 1) {
            zoom = 1;
        }
        p.setZoom(zoom);
        mCamera.setParameters(p);
    }
}

