/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.helper;

import android.hardware.Camera;

public class LightHelper {
    static long lastRecordTime = System.currentTimeMillis();
    static int darkIndex = 0;
    static long[] darkList = new long[]{255L, 255L, 255L, 255L};
    static int waitScanTime = 300;
    static int lastAvDark = 0;

    public static int getAvDark(byte[] data, int dataWidth, int dataheight) {
        if (data.length == 0) {
            return lastAvDark;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastRecordTime < (long)waitScanTime) {
            return lastAvDark;
        }
        lastRecordTime = currentTime;
        long pixelLightCount = 0L;
        long pixeCount = dataWidth * dataheight;
        int step = 10;
        if (Math.abs((float)data.length - (float)pixeCount * 1.5f) < 1.0E-5f) {
            int i = 0;
            while ((long)i < pixeCount) {
                pixelLightCount += (long)data[i] & 0xFFL;
                i += step;
            }
            long cameraLight = pixelLightCount / (pixeCount / (long)step);
            int lightSize = darkList.length;
            LightHelper.darkList[LightHelper.darkIndex %= lightSize] = cameraLight;
            ++darkIndex;
            int avDark = 0;
            for (int i2 = 0; i2 < lightSize; ++i2) {
                avDark = (int)((long)avDark + darkList[i2]);
            }
            lastAvDark = avDark /= lightSize;
            return avDark;
        }
        return lastAvDark;
    }

    public static void openLight(Camera mCamera, boolean isOpen) {
        if (mCamera == null) {
            return;
        }
        Camera.Parameters parameters = mCamera.getParameters();
        if (isOpen) {
            parameters.setFlashMode("torch");
        } else {
            parameters.setFlashMode("off");
        }
        mCamera.setParameters(parameters);
    }
}

