/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.helper;

import android.graphics.PointF;
import android.graphics.Rect;
import com.ailiwean.core.Config;
import com.ailiwean.core.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.HybridBinarizer;

public class ScanHelper {
    public static BinaryBitmap byteToBinaryBitmap(byte[] bytes, int dataWidth, int dataHeight) {
        Rect rect = ScanHelper.getScanByteRect(dataWidth, dataHeight);
        PlanarYUVLuminanceSource source = ScanHelper.buildLuminanceSource(bytes, dataWidth, dataHeight, rect);
        return new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
    }

    private static Rect rotateRect(Rect rect) {
        Rect rect1 = new Rect();
        rect1.left = rect.top;
        rect1.top = rect.left;
        rect1.right = rect.bottom;
        rect1.bottom = rect.right;
        return rect1;
    }

    public static PointF rotatePoint(ResultPoint[] point) {
        if (point == null || point.length == 0) {
            return new PointF(0.0f, 0.0f);
        }
        if (Config.scanRect.getScanR() == null) {
            return new PointF(0.0f, 0.0f);
        }
        PointF avargPoint = new PointF();
        for (ResultPoint item : point) {
            avargPoint.x += Math.abs(item.getX());
            avargPoint.y += Math.abs(item.getY());
        }
        avargPoint.x /= (float)point.length;
        avargPoint.y /= (float)point.length;
        float preX = Config.scanRect.getPreX();
        float preY = Config.scanRect.getPreY();
        float aspX = preX / (float)Config.scanRect.getScanR().height();
        float aspY = preY / (float)Config.scanRect.getScanR().width();
        return new PointF(preX - aspX * avargPoint.y, aspY * avargPoint.x);
    }

    public static PointF rotatePointR(ResultPoint[] point) {
        if (point == null || point.length == 0) {
            return new PointF(0.0f, 0.0f);
        }
        if (Config.scanRect.getScanRR() == null) {
            return new PointF(0.0f, 0.0f);
        }
        PointF avargPoint = new PointF();
        for (ResultPoint item : point) {
            avargPoint.x += Math.abs(item.getX());
            avargPoint.y += Math.abs(item.getY());
        }
        avargPoint.x /= (float)point.length;
        avargPoint.y /= (float)point.length;
        float preX = Config.scanRect.getPreX();
        float preY = Config.scanRect.getPreY();
        float aspX = preX / (float)Config.scanRect.getScanRR().width();
        float aspY = preY / (float)Config.scanRect.getScanRR().height();
        return new PointF(aspX * avargPoint.x, aspY * avargPoint.y);
    }

    private static PlanarYUVLuminanceSource buildLuminanceSource(byte[] data, int width, int height, Rect rect) {
        if (rect.left == 0 && rect.right == 0 || rect.top == 0 && rect.bottom == 0) {
            try {
                throw new Exception("\u626b\u7801\u89e3\u6790\u533a\u57df\u5f02\u5e38");
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return new PlanarYUVLuminanceSource(data, width, height, rect.left, rect.top, rect.width(), rect.height(), false);
    }

    public static Rect getScanByteRect(int dataWidth, int dataHeight) {
        if (dataWidth > dataHeight) {
            if (Config.scanRect.getScanR() == null) {
                Config.scanRect.setScanR(new Rect());
            }
            Config.scanRect.getScanR().left = (int)(Config.scanRect.getRect().left * (float)dataHeight);
            Config.scanRect.getScanR().top = (int)(Config.scanRect.getRect().top * (float)dataWidth);
            Config.scanRect.getScanR().right = (int)(Config.scanRect.getRect().right * (float)dataHeight);
            Config.scanRect.getScanR().bottom = (int)(Config.scanRect.getRect().bottom * (float)dataWidth);
            Config.scanRect.setScanR(ScanHelper.rotateRect(Config.scanRect.getScanR()));
            return Config.scanRect.getScanR();
        }
        if (Config.scanRect.getScanRR() == null) {
            Config.scanRect.setScanRR(new Rect());
        }
        Config.scanRect.getScanRR().left = (int)(Config.scanRect.getRect().left * (float)dataWidth);
        Config.scanRect.getScanRR().top = (int)(Config.scanRect.getRect().top * (float)dataHeight);
        Config.scanRect.getScanRR().right = (int)(Config.scanRect.getRect().right * (float)dataWidth);
        Config.scanRect.getScanRR().bottom = (int)(Config.scanRect.getRect().bottom * (float)dataHeight);
        return Config.scanRect.getScanRR();
    }

    public static int getQrLenght(ResultPoint[] point) {
        if (Config.scanRect.getScanR() == null) {
            return 0;
        }
        PointF avargPoint = new PointF();
        for (ResultPoint item : point) {
            avargPoint.x += item.getX();
            avargPoint.y += item.getY();
        }
        avargPoint.x /= (float)point.length;
        avargPoint.y /= (float)point.length;
        int sideA = (int)(avargPoint.x - point[0].getX());
        int sideB = (int)(avargPoint.y - point[0].getY());
        float preX = Config.scanRect.getPreX();
        float aspX = preX / (float)Config.scanRect.getScanR().height();
        return (int)(Math.sqrt(sideA * sideA + sideB * sideB) / Math.sqrt(2.0) * 2.0 * (double)aspX);
    }
}

