/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.cameraview.R;

public class LightView
extends FrameLayout {
    private TextView tv;
    private ImageView iv;
    private LightClick lightClick;
    private boolean isBright;

    public LightView(Context context) {
        super(context);
        this.initView();
    }

    public LightView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public LightView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        View v = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.light_layout, null);
        this.iv = (ImageView)v.findViewById(R.id.light_img);
        this.tv = (TextView)v.findViewById(R.id.light_text);
        this.addView(v);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LightView.this.toggle();
            }
        });
    }

    public void toggle() {
        if (this.tv.getText().equals("\u8f7b\u89e6\u7167\u4eae")) {
            this.open();
        } else {
            this.close();
        }
    }

    private void open() {
        this.isBright = true;
        this.tv.setText((CharSequence)"\u8f7b\u89e6\u5173\u95ed");
        if (this.lightClick != null) {
            this.lightClick.onClick(true);
        }
        this.iv.setImageDrawable(this.getContext().getResources().getDrawable(R.drawable.light_open));
    }

    private void close() {
        this.isBright = false;
        this.tv.setText((CharSequence)"\u8f7b\u89e6\u7167\u4eae");
        if (this.lightClick != null) {
            this.lightClick.onClick(false);
        }
        this.iv.setImageDrawable(this.getContext().getResources().getDrawable(R.drawable.light_close));
    }

    public void inital() {
        this.close();
        this.setVisibility(8);
    }

    public void setBright(boolean isBright) {
        if (!isBright) {
            this.setVisibility(0);
        } else if (!this.isBright) {
            this.setVisibility(4);
        }
    }

    public void regLightClick(LightClick click) {
        this.lightClick = click;
    }

    public static interface LightClick {
        public void onClick(boolean var1);
    }
}

