/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WorkThreadServer {
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, corePoolSize, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(maximumPoolSize, true), new ThreadPoolExecutor.DiscardOldestPolicy());
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int corePoolSize = Math.max(2, Math.min(CPU_COUNT - 1, 4));
    private static final int maximumPoolSize = CPU_COUNT * 2 + 1;
    private static final int keepAliveTime = 30;

    private WorkThreadServer() {
    }

    public static WorkThreadServer createInstance() {
        return new WorkThreadServer();
    }

    public void post(Runnable runnable) {
        if (this.executor != null) {
            this.executor.execute(runnable);
        }
    }

    public void quit() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }
}

